/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind.select;

import com.tobiasdiez.easybind.select.NestedSelectionElement;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;

class LeafSelectionElement<T, U>
implements NestedSelectionElement<T, U> {
    private final Runnable onInvalidation;
    private final InvalidationListener observableInvalidationListener = obs -> this.observableInvalidated();
    private final Function<? super T, ObservableValue<U>> selector;
    private ObservableValue<U> observable = null;

    public LeafSelectionElement(Runnable onInvalidation, Function<? super T, ObservableValue<U>> selector) {
        this.onInvalidation = onInvalidation;
        this.selector = selector;
    }

    @Override
    public void connect(T baseVal) {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        this.observable = this.selector.apply(baseVal);
        this.observable.addListener(this.observableInvalidationListener);
    }

    @Override
    public void disconnect() {
        if (this.isConnected()) {
            this.observable.removeListener(this.observableInvalidationListener);
            this.observable = null;
        }
    }

    @Override
    public final boolean isConnected() {
        return this.observable != null;
    }

    @Override
    public U getValue() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        return (U)this.observable.getValue();
    }

    private void observableInvalidated() {
        this.onInvalidation.run();
    }
}

