/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.viewlist;

import de.saxsys.mvvmfx.FluentViewLoader;
import de.saxsys.mvvmfx.FxmlView;
import de.saxsys.mvvmfx.JavaView;
import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.ViewTuple;
import de.saxsys.mvvmfx.internal.viewloader.View;
import de.saxsys.mvvmfx.utils.viewlist.ViewListCellFactory;
import java.util.HashMap;
import java.util.Map;
import javafx.util.Callback;

public class CachedViewModelCellFactory<V extends View<VM>, VM extends ViewModel>
implements ViewListCellFactory<VM> {
    private Map<VM, ViewTuple<V, VM>> cache = new HashMap<VM, ViewTuple<V, VM>>();
    private Callback<VM, ViewTuple<V, VM>> loadFactory;

    public CachedViewModelCellFactory(Callback<VM, ViewTuple<V, VM>> loadFactory) {
        this.loadFactory = loadFactory;
    }

    @Override
    public ViewTuple<V, VM> map(VM viewModel) {
        if (!this.cache.containsKey(viewModel)) {
            ViewTuple viewTuple = (ViewTuple)this.loadFactory.call(viewModel);
            this.cache.put(viewModel, viewTuple);
        }
        return this.cache.get(viewModel);
    }

    public static <V extends View<VM>, VM extends ViewModel> CachedViewModelCellFactory<V, VM> create(Callback<VM, ViewTuple<V, VM>> callback) {
        return new CachedViewModelCellFactory<V, VM>(callback);
    }

    public static <V extends FxmlView<VM>, VM extends ViewModel> CachedViewModelCellFactory<V, VM> createForFxmlView(Class<V> viewType) {
        return CachedViewModelCellFactory.create(vm -> FluentViewLoader.fxmlView(viewType).viewModel((ViewModel)vm).load());
    }

    public static <V extends JavaView<VM>, VM extends ViewModel> CachedViewModelCellFactory<V, VM> createForJavaView(Class<V> viewType) {
        return CachedViewModelCellFactory.create(vm -> FluentViewLoader.javaView(viewType).viewModel((ViewModel)vm).load());
    }
}

