/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import de.saxsys.mvvmfx.InjectResourceBundle;
import de.saxsys.mvvmfx.internal.viewloader.ReflectionUtils;
import de.saxsys.mvvmfx.internal.viewloader.ResourceBundleManager;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

class ResourceBundleInjector {
    ResourceBundleInjector() {
    }

    static void injectResourceBundle(Object target, ResourceBundle resourceBundle) {
        List<Field> fieldsWithAnnotation = ReflectionUtils.getFieldsWithAnnotation(target, InjectResourceBundle.class);
        boolean notAssignableFieldPresent = fieldsWithAnnotation.stream().anyMatch(field -> !field.getType().isAssignableFrom(ResourceBundle.class));
        if (notAssignableFieldPresent) {
            throw new IllegalStateException("The class [" + target + "] has at least one field with the annotation @InjectResourceBundle but the field is not of type ResourceBundle.");
        }
        if (resourceBundle == null || resourceBundle.equals(ResourceBundleManager.EMPTY_RESOURCE_BUNDLE)) {
            boolean nonOptionalFieldsPresent;
            if (!fieldsWithAnnotation.isEmpty() && (nonOptionalFieldsPresent = fieldsWithAnnotation.stream().flatMap(field -> Arrays.stream(field.getAnnotationsByType(InjectResourceBundle.class))).anyMatch(annotation -> !annotation.optional()))) {
                throw new IllegalStateException("The class [" + target + "] expects a ResourceBundle to be injected but no ResourceBundle was defined while loading.");
            }
        } else {
            fieldsWithAnnotation.forEach(field -> {
                if (!field.getType().isAssignableFrom(ResourceBundle.class)) {
                    throw new IllegalStateException("The class [" + target + "] has a field with the @InjectResourceBundle annotation but the type of the field doesn't match ResourceBundle");
                }
                ReflectionUtils.setField(field, target, resourceBundle);
            });
        }
    }
}

