/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.tokens;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import uk.ac.ed.ph.snuggletex.definitions.ComputedStyle;
import uk.ac.ed.ph.snuggletex.definitions.LaTeXMode;
import uk.ac.ed.ph.snuggletex.internal.FrozenSlice;
import uk.ac.ed.ph.snuggletex.internal.util.DumpMode;
import uk.ac.ed.ph.snuggletex.internal.util.ObjectDumperOptions;
import uk.ac.ed.ph.snuggletex.semantics.Interpretation;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;
import uk.ac.ed.ph.snuggletex.tokens.Token;
import uk.ac.ed.ph.snuggletex.tokens.TokenType;

@ObjectDumperOptions(value=DumpMode.DEEP)
public final class ArgumentContainerToken
extends Token
implements Iterable<FlowToken> {
    public static final ArgumentContainerToken[] EMPTY_ARRAY = new ArgumentContainerToken[0];
    private final List<FlowToken> contents;

    public ArgumentContainerToken(FrozenSlice slice, LaTeXMode latexMode, List<FlowToken> contents) {
        super(slice, TokenType.ARGUMENT_CONTAINER, latexMode, new Interpretation[0]);
        this.contents = contents;
    }

    public ArgumentContainerToken(FrozenSlice slice, LaTeXMode latexMode, List<FlowToken> contents, ComputedStyle computedStyle) {
        super(slice, TokenType.ARGUMENT_CONTAINER, latexMode, new Interpretation[0]);
        this.contents = contents;
        this.computedStyle = computedStyle;
    }

    public static ArgumentContainerToken createFromSingleToken(LaTeXMode latexMode, FlowToken content) {
        return ArgumentContainerToken.createFromSingleToken(latexMode, content, content.getComputedStyle());
    }

    public static ArgumentContainerToken createFromSingleToken(LaTeXMode latexMode, FlowToken content, ComputedStyle computedStyle) {
        ArrayList<FlowToken> contentList = new ArrayList<FlowToken>();
        contentList.add(content);
        return new ArgumentContainerToken(content.getSlice(), latexMode, contentList, computedStyle);
    }

    public static ArgumentContainerToken createFromContiguousTokens(Token parentToken, LaTeXMode latexMode, List<? extends FlowToken> contents, ComputedStyle computedStyle) {
        return ArgumentContainerToken.createFromContiguousTokens(parentToken, latexMode, contents, 0, contents.size(), computedStyle);
    }

    public static ArgumentContainerToken createFromContiguousTokens(Token parentToken, LaTeXMode latexMode, List<? extends FlowToken> contents, int startIndex, int endIndex, ComputedStyle computedStyle) {
        ArgumentContainerToken result;
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("startIndex must be <= endIndex");
        }
        if (contents.size() > 0) {
            FrozenSlice startSlice = contents.get(startIndex).getSlice();
            FrozenSlice endSlice = contents.get(endIndex - 1).getSlice();
            FrozenSlice resultSlice = startSlice.rightOuterSpan(endSlice);
            result = new ArgumentContainerToken(resultSlice, latexMode, new ArrayList<FlowToken>(contents.subList(startIndex, endIndex)), computedStyle);
        } else {
            result = ArgumentContainerToken.createEmptyContainer(parentToken, latexMode, computedStyle);
        }
        return result;
    }

    public static ArgumentContainerToken createEmptyContainer(Token parentToken, LaTeXMode latexMode, ComputedStyle computedStyle) {
        List<FlowToken> emptyTokens = Collections.emptyList();
        return new ArgumentContainerToken(parentToken.getSlice(), latexMode, emptyTokens, computedStyle);
    }

    @ObjectDumperOptions(value=DumpMode.DEEP)
    public List<FlowToken> getContents() {
        return this.contents;
    }

    @Override
    public Iterator<FlowToken> iterator() {
        return this.contents.iterator();
    }
}

