/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MakeCharacterDefinitions {
    public static void main(String[] args) throws Exception {
        String line;
        if (args.length != 2) {
            throw new IllegalArgumentException("The unicode-math-table.tex input and all-math-characters.txt output text files must both be provided");
        }
        String inputFile = args[0];
        String outputFile = args[1];
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "US-ASCII"));
        BufferedWriter characterFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "US-ASCII"));
        characterFileWriter.write("# This was generated from " + inputFile + " during the SnuggleTeX build - do not edit!\n");
        Pattern linePattern = Pattern.compile("\\\\UnicodeMathSymbol\\{\"(.{5})\\}\\{\\\\(\\w+)\\s*\\}\\{\\\\(\\w+)\\}");
        HashMap<String, Integer> typeFrequencyMap = new HashMap<String, Integer>();
        int count = 0;
        while ((line = reader.readLine()) != null) {
            ++count;
            Matcher matcher = linePattern.matcher(line);
            if (matcher.find()) {
                String codePointHex = matcher.group(1);
                String commandName = matcher.group(2);
                String type = matcher.group(3);
                Integer frequency = (Integer)typeFrequencyMap.get(type);
                frequency = frequency == null ? Integer.valueOf(1) : Integer.valueOf(frequency + 1);
                typeFrequencyMap.put(type, frequency);
                if (type.equals("mathalpha") || type.equals("mathord") || type.equals("mathop") || type.equals("mathpunct") || type.equals("mathrel") || type.equals("mathbin") || type.equals("mathaccent") || type.equals("mathopen") || type.equals("mathclose") || type.equals("mathfence")) {
                    // empty if block
                }
                characterFileWriter.write(codePointHex);
                characterFileWriter.write(58);
                characterFileWriter.write(commandName);
                characterFileWriter.write(58);
                characterFileWriter.write(type.substring(4).toUpperCase());
                characterFileWriter.write(10);
                continue;
            }
            throw new RuntimeException("Could not parse line " + line);
        }
        reader.close();
        characterFileWriter.close();
        System.out.println("Types were " + typeFrequencyMap);
        System.out.println("Number of chars is " + count);
    }
}

