/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.dombuilding;

import java.util.List;
import org.w3c.dom.Element;
import uk.ac.ed.ph.snuggletex.definitions.CoreErrorCode;
import uk.ac.ed.ph.snuggletex.dombuilding.EnvironmentHandler;
import uk.ac.ed.ph.snuggletex.dombuilding.TabularHandler;
import uk.ac.ed.ph.snuggletex.internal.DOMBuilder;
import uk.ac.ed.ph.snuggletex.internal.SnuggleParseException;
import uk.ac.ed.ph.snuggletex.tokens.CommandToken;
import uk.ac.ed.ph.snuggletex.tokens.EnvironmentToken;
import uk.ac.ed.ph.snuggletex.tokens.FlowToken;

public final class MatrixHandler
implements EnvironmentHandler {
    private final String opener;
    private final String closer;
    private final int maxColumns;

    public MatrixHandler() {
        this(0, null, null);
    }

    public MatrixHandler(String opener, String closer) {
        this(0, opener, closer);
    }

    public MatrixHandler(int maxColumns, String opener, String closer) {
        this.maxColumns = maxColumns;
        this.opener = opener;
        this.closer = closer;
    }

    @Override
    public void handleEnvironment(DOMBuilder builder, Element parentElement, EnvironmentToken token) throws SnuggleParseException {
        Element tableContainer;
        if (this.opener != null) {
            tableContainer = builder.appendMathMLElement(parentElement, "mfenced");
            tableContainer.setAttribute("open", this.opener);
            tableContainer.setAttribute("close", this.closer);
        } else {
            tableContainer = parentElement;
        }
        int[] geometry = TabularHandler.computeTableDimensions(token.getContent());
        int numColumns = geometry[1];
        Element mtableElement = builder.appendMathMLElement(tableContainer, "mtable");
        for (FlowToken rowToken : token.getContent()) {
            int i;
            Element mtrElement = builder.appendMathMLElement(mtableElement, "mtr");
            List<FlowToken> columns = ((CommandToken)rowToken).getArguments()[0].getContents();
            int rowColumns = columns.size();
            if (this.maxColumns > 0 && rowColumns > this.maxColumns) {
                builder.appendOrThrowError(mtrElement, rowToken, CoreErrorCode.TDEMM0, token.getEnvironment().getTeXName(), this.maxColumns);
                continue;
            }
            for (i = 0; i < numColumns && i < rowColumns; ++i) {
                FlowToken columnToken = columns.get(i);
                Element mtdElement = builder.appendMathMLElement(mtrElement, "mtd");
                builder.handleTokens(mtdElement, ((CommandToken)columnToken).getArguments()[0].getContents(), true);
            }
            for (i = 0; i < numColumns - rowColumns; ++i) {
                builder.appendMathMLElement(mtrElement, "mtd");
            }
        }
    }
}

