/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.infocenter;

import com.dlsc.gemsfx.infocenter.Notification;
import com.dlsc.gemsfx.infocenter.NotificationGroup;
import com.dlsc.gemsfx.skins.InfoCenterViewSkin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class InfoCenterView
extends Control {
    private static final String TRANSPARENT = "transparent";
    private static final double DEFAULT_NOTIFICATION_SPACING = 10.0;
    private static final Duration DEFAULT_EXPAND_DURATION = Duration.millis((double)300.0);
    private static final Duration DEFAULT_SLIDE_IN_DURATION = Duration.millis((double)500.0);
    private static final boolean DEFAULT_AUTO_OPEN_GROUP = false;
    private static final boolean DEFAULT_TRANSPARENT = false;
    private static final Node DEFAULT_PLACEHOLDER = InfoCenterView.createDefaultPlaceholder();
    private final InvalidationListener updateNotificationsListener = it -> this.updateNotificationsList();
    private final WeakInvalidationListener weakUpdateNotificationsListener = new WeakInvalidationListener(this.updateNotificationsListener);
    private final InvalidationListener updatePinnedGroupsListener = it -> this.updatePinnedAndUnpinnedGroupsList();
    private final WeakInvalidationListener weakUpdatePinnedGroupsListener = new WeakInvalidationListener(this.updatePinnedGroupsListener);
    private final ObservableList<NotificationGroup<?, ?>> groups = FXCollections.observableArrayList();
    private final ObservableList<NotificationGroup<?, ?>> unpinnedGroups = FXCollections.observableArrayList();
    private final ObservableList<NotificationGroup<?, ?>> unmodifiableUnpinnedGroups = FXCollections.unmodifiableObservableList(this.unpinnedGroups);
    private final ObservableList<NotificationGroup<?, ?>> pinnedGroups = FXCollections.observableArrayList();
    private final ObservableList<NotificationGroup<?, ?>> unmodifiablePinnedGroups = FXCollections.unmodifiableObservableList(this.pinnedGroups);
    private final ObjectProperty<Consumer<NotificationGroup<?, ?>>> onShowAllGroupNotifications = new SimpleObjectProperty((Object)this, "onShowAllGroupNotifications");
    private BooleanProperty autoOpenGroup;
    private final ObservableList<Notification<?>> notifications = FXCollections.observableArrayList();
    private final ObservableList<Notification<?>> unmodifiableNotifications = FXCollections.unmodifiableObservableList(this.notifications);
    private final ObservableList<Notification<?>> pinnedNotifications = FXCollections.observableArrayList();
    private final ObservableList<Notification<?>> unmodifiablePinnedNotifications = FXCollections.unmodifiableObservableList(this.pinnedNotifications);
    private final ObservableList<Notification<?>> unpinnedNotifications = FXCollections.observableArrayList();
    private final ObservableList<Notification<?>> unmodifiableUnpinnedNotifications = FXCollections.unmodifiableObservableList(this.unpinnedNotifications);
    private final ObjectProperty<NotificationGroup> showAllGroup = new SimpleObjectProperty((Object)this, "showAllGroup");
    private final ObjectProperty<Duration> showAllFadeDuration = new SimpleObjectProperty((Object)this, "showAllFadeDuration", (Object)Duration.millis((double)300.0));
    private ObjectProperty<Duration> expandDuration;
    private ObjectProperty<Duration> slideInDuration;
    private BooleanProperty transparent;
    private ObjectProperty<Node> placeholder;
    private DoubleProperty notificationSpacing;

    public InfoCenterView() {
        this.getStyleClass().add((Object)"info-center-view");
        ListChangeListener groupListListener = change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(group -> {
                        group.getNotifications().addListener((InvalidationListener)this.weakUpdateNotificationsListener);
                        group.pinnedProperty().addListener((InvalidationListener)this.weakUpdateNotificationsListener);
                        group.pinnedProperty().addListener((InvalidationListener)this.weakUpdatePinnedGroupsListener);
                    });
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(group -> {
                    group.getNotifications().removeListener((InvalidationListener)this.weakUpdateNotificationsListener);
                    group.pinnedProperty().removeListener((InvalidationListener)this.weakUpdateNotificationsListener);
                    group.pinnedProperty().removeListener((InvalidationListener)this.weakUpdatePinnedGroupsListener);
                });
            }
            this.updateNotificationsList();
            this.updatePinnedAndUnpinnedGroupsList();
        };
        this.getGroups().addListener(groupListListener);
        this.setFocusTraversable(false);
    }

    protected Skin<?> createDefaultSkin() {
        return new InfoCenterViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(InfoCenterView.class.getResource("info-center-view.css")).toExternalForm();
    }

    private void updateStyle() {
        this.getStyleClass().remove((Object)TRANSPARENT);
        if (this.isTransparent()) {
            this.getStyleClass().add((Object)TRANSPARENT);
        }
    }

    private void updateNotificationsList() {
        ArrayList allNotifications = new ArrayList();
        ArrayList allPinnedNotifications = new ArrayList();
        ArrayList allUnpinnedNotifications = new ArrayList();
        this.getGroups().forEach(group -> {
            allNotifications.addAll(group.getNotifications());
            if (group.isPinned()) {
                allPinnedNotifications.addAll(group.getNotifications());
            } else {
                allUnpinnedNotifications.addAll(group.getNotifications());
            }
        });
        this.notifications.setAll(allNotifications);
        this.pinnedNotifications.setAll(allPinnedNotifications);
        this.unpinnedNotifications.setAll(allUnpinnedNotifications);
    }

    private void updatePinnedAndUnpinnedGroupsList() {
        this.pinnedGroups.setAll((Collection)this.getGroups().stream().filter(group -> group.isPinned()).collect(Collectors.toList()));
        this.unpinnedGroups.setAll((Collection)this.getGroups().stream().filter(group -> !group.isPinned()).collect(Collectors.toList()));
    }

    public final ObservableList<NotificationGroup<?, ?>> getGroups() {
        return this.groups;
    }

    public final ObservableList<NotificationGroup<?, ?>> getUnmodifiableUnpinnedGroups() {
        return this.unmodifiableUnpinnedGroups;
    }

    public final ObservableList<NotificationGroup<?, ?>> getUnmodifiablePinnedGroups() {
        return this.unmodifiablePinnedGroups;
    }

    public final Consumer<NotificationGroup<?, ?>> getOnShowAllGroupNotifications() {
        return (Consumer)this.onShowAllGroupNotifications.get();
    }

    public final ObjectProperty<Consumer<NotificationGroup<?, ?>>> onShowAllGroupNotificationsProperty() {
        return this.onShowAllGroupNotifications;
    }

    public final void setOnShowAllGroupNotifications(Consumer<NotificationGroup<?, ?>> onShowAllGroupNotifications) {
        this.onShowAllGroupNotifications.set(onShowAllGroupNotifications);
    }

    public final boolean isAutoOpenGroup() {
        return this.autoOpenGroup == null ? false : this.autoOpenGroup.get();
    }

    public final BooleanProperty autoOpenGroupProperty() {
        if (this.autoOpenGroup == null) {
            this.autoOpenGroup = new SimpleBooleanProperty((Object)this, "autoOpenGroup", false);
        }
        return this.autoOpenGroup;
    }

    public final void setAutoOpenGroup(boolean autoOpenGroup) {
        this.autoOpenGroupProperty().set(autoOpenGroup);
    }

    public final ObservableList<Notification<?>> getUnmodifiableNotifications() {
        return this.unmodifiableNotifications;
    }

    public final ObservableList<Notification<?>> getUnmodifiablePinnedNotifications() {
        return this.unmodifiablePinnedNotifications;
    }

    public final ObservableList<Notification<?>> getUnmodifiableUnpinnedNotifications() {
        return this.unmodifiableUnpinnedNotifications;
    }

    public final NotificationGroup getShowAllGroup() {
        return (NotificationGroup)this.showAllGroup.get();
    }

    public final ObjectProperty<NotificationGroup> showAllGroupProperty() {
        return this.showAllGroup;
    }

    public final void setShowAllGroup(NotificationGroup showAllGroup) {
        this.showAllGroup.set((Object)showAllGroup);
    }

    public final Duration getShowAllFadeDuration() {
        return (Duration)this.showAllFadeDuration.get();
    }

    public final ObjectProperty<Duration> showAllFadeDurationProperty() {
        return this.showAllFadeDuration;
    }

    public final void setShowAllFadeDuration(Duration showAllFadeDuration) {
        this.showAllFadeDuration.set((Object)showAllFadeDuration);
    }

    public final Duration getExpandDuration() {
        return this.expandDuration == null ? DEFAULT_EXPAND_DURATION : (Duration)this.expandDuration.get();
    }

    public final ObjectProperty<Duration> expandDurationProperty() {
        if (this.expandDuration == null) {
            this.expandDuration = new SimpleObjectProperty((Object)this, "expandDuration", (Object)DEFAULT_EXPAND_DURATION);
        }
        return this.expandDuration;
    }

    public final void setExpandDuration(Duration expandDuration) {
        this.expandDurationProperty().set((Object)expandDuration);
    }

    public final Duration getSlideInDuration() {
        return this.slideInDuration == null ? DEFAULT_SLIDE_IN_DURATION : (Duration)this.slideInDuration.get();
    }

    public final ObjectProperty<Duration> slideInDurationProperty() {
        if (this.slideInDuration == null) {
            this.slideInDuration = new SimpleObjectProperty((Object)this, "slideInDuration", (Object)DEFAULT_SLIDE_IN_DURATION);
        }
        return this.slideInDuration;
    }

    public final void setSlideInDuration(Duration slideInDuration) {
        this.slideInDurationProperty().set((Object)slideInDuration);
    }

    public final boolean isTransparent() {
        return this.transparent == null ? false : this.transparent.get();
    }

    public final BooleanProperty transparentProperty() {
        if (this.transparent == null) {
            this.transparent = new SimpleBooleanProperty((Object)this, TRANSPARENT, false){

                protected void invalidated() {
                    InfoCenterView.this.updateStyle();
                }
            };
        }
        return this.transparent;
    }

    public final void setTransparent(boolean transparent) {
        this.transparentProperty().set(transparent);
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty((Object)this, "placeholder", (Object)DEFAULT_PLACEHOLDER);
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node placeholder) {
        this.placeholderProperty().set((Object)placeholder);
    }

    public final Node getPlaceholder() {
        return this.placeholder == null ? DEFAULT_PLACEHOLDER : (Node)this.placeholder.get();
    }

    private static StackPane createDefaultPlaceholder() {
        FontIcon graphic = new FontIcon((Ikon)MaterialDesign.MDI_CREATION);
        graphic.setIconSize(20);
        graphic.setIconColor((Paint)Color.WHITE);
        Label noNotifications = new Label("No notifications", (Node)graphic);
        StackPane placeholder = new StackPane(new Node[]{noNotifications});
        placeholder.getStyleClass().add((Object)"default-placeholder");
        return placeholder;
    }

    public final DoubleProperty notificationSpacingProperty() {
        if (this.notificationSpacing == null) {
            this.notificationSpacing = new StyleableDoubleProperty(10.0){

                public Object getBean() {
                    return InfoCenterView.this;
                }

                public String getName() {
                    return "notificationSpacing";
                }

                public CssMetaData<? extends Styleable, Number> getCssMetaData() {
                    return StyleableProperties.NOTIFICATION_SPACING;
                }
            };
        }
        return this.notificationSpacing;
    }

    public final double getNotificationSpacing() {
        return this.notificationSpacing == null ? 10.0 : this.notificationSpacing.get();
    }

    public final void setNotificationSpacing(double notificationSpacing) {
        this.notificationSpacingProperty().set(notificationSpacing);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return InfoCenterView.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public void clearAll() {
        this.getGroups().forEach(group -> group.getNotifications().clear());
    }

    private static class StyleableProperties {
        private static final CssMetaData<InfoCenterView, Number> NOTIFICATION_SPACING = new CssMetaData<InfoCenterView, Number>("-fx-notification-spacing", SizeConverter.getInstance(), (Number)10.0){

            public boolean isSettable(InfoCenterView view) {
                return view.notificationSpacing == null || !view.notificationSpacing.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(InfoCenterView view) {
                return (StyleableProperty)view.notificationSpacingProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<InfoCenterView, Number>> styleables = new ArrayList<CssMetaData<InfoCenterView, Number>>(Control.getClassCssMetaData());
            styleables.add(NOTIFICATION_SPACING);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

