/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.extensions;

import java.io.Serializable;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.JavaProjectHelper;
import org.javamodularity.moduleplugin.extensions.CompileModuleOptions;
import org.javamodularity.moduleplugin.extensions.ModularityExtension;
import org.javamodularity.moduleplugin.extensions.OptionContainer;
import org.javamodularity.moduleplugin.tasks.ClasspathFile;

public class DefaultModularityExtension
implements ModularityExtension {
    private final Project project;
    private final OptionContainer optionContainer = new OptionContainer();

    public DefaultModularityExtension(Project project) {
        this.project = project;
    }

    @Override
    public void standardJavaRelease(int mainJavaRelease) {
        if (mainJavaRelease < 9) {
            throw new IllegalArgumentException(String.format("Invalid main --release value: %d. Use 'mixedJavaRelease' instead.", mainJavaRelease));
        }
        this.project.afterEvaluate((Action & Serializable)p -> this.configureStandardJavaRelease(mainJavaRelease));
    }

    private void configureStandardJavaRelease(int mainJavaRelease) {
        JavaCompile compileJava = this.helper().compileJavaTask("compileJava");
        this.setJavaRelease(compileJava, mainJavaRelease);
    }

    @Override
    public void mixedJavaRelease(int mainJavaRelease, int moduleInfoJavaRelease) {
        DefaultModularityExtension.validateMixedJavaReleaseArgs(mainJavaRelease, moduleInfoJavaRelease);
        CompileModuleOptions moduleOptions = (CompileModuleOptions)this.helper().compileJavaTask("compileJava").getExtensions().getByType(CompileModuleOptions.class);
        moduleOptions.setCompileModuleInfoSeparately(true);
        this.project.afterEvaluate((Action & Serializable)p -> this.configureMixedJavaRelease(mainJavaRelease, moduleInfoJavaRelease));
    }

    @Override
    public OptionContainer optionContainer() {
        return this.optionContainer;
    }

    private static void validateMixedJavaReleaseArgs(int mainJavaRelease, int moduleInfoJavaRelease) {
        if (mainJavaRelease < 6) {
            throw new IllegalArgumentException("Invalid main --release value: " + mainJavaRelease);
        }
        if (mainJavaRelease > 8) {
            throw new IllegalArgumentException(String.format("Invalid main --release value: %d. Use 'standardJavaRelease' instead.", mainJavaRelease));
        }
        if (moduleInfoJavaRelease < 9) {
            throw new IllegalArgumentException("Invalid module-info --release value: " + moduleInfoJavaRelease);
        }
    }

    private void configureMixedJavaRelease(int mainJavaRelease, int moduleInfoJavaRelease) {
        JavaCompile compileJava = this.helper().compileJavaTask("compileJava");
        this.setJavaRelease(compileJava, mainJavaRelease);
        JavaCompile compileModuleInfoJava = this.helper().compileJavaTask("compileModuleInfoJava");
        this.setJavaRelease(compileModuleInfoJava, moduleInfoJavaRelease);
    }

    private void setJavaRelease(JavaCompile javaCompile, int javaRelease) {
        String toolchainVersion;
        JavaToolchainSpec toolchain;
        String currentJavaVersion = JavaVersion.current().toString();
        if (this.toolchainIsSupported() && (toolchain = ((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getToolchain()) != null && (toolchainVersion = (String)toolchain.getLanguageVersion().map(Object::toString).getOrNull()) != null) {
            currentJavaVersion = toolchainVersion;
        }
        if (!javaCompile.getSourceCompatibility().equals(currentJavaVersion)) {
            throw new IllegalStateException("sourceCompatibility should not be set together with --release option");
        }
        if (!javaCompile.getTargetCompatibility().equals(currentJavaVersion)) {
            throw new IllegalStateException("targetCompatibility should not be set together with --release option");
        }
        List compilerArgs = javaCompile.getOptions().getCompilerArgs();
        if (compilerArgs.contains("--release")) {
            throw new IllegalStateException("--release option is already set in compiler args");
        }
        if (this.releaseOptionIsSupported()) {
            javaCompile.getOptions().getRelease().convention((Object)javaRelease);
        } else {
            compilerArgs.add("--release");
            compilerArgs.add(String.valueOf(javaRelease));
        }
    }

    private boolean releaseOptionIsSupported() {
        return GradleVersion.current().compareTo(GradleVersion.version((String)"6.6")) >= 0;
    }

    private boolean toolchainIsSupported() {
        return GradleVersion.current().compareTo(GradleVersion.version((String)"6.7")) >= 0;
    }

    private JavaProjectHelper helper() {
        return new JavaProjectHelper(this.project);
    }

    @Override
    public void improveEclipseClasspathFile() {
        this.project.afterEvaluate((Action & Serializable)p -> this.helper().findTask("eclipseClasspath", Task.class).ifPresent(new ClasspathFile()::configure));
    }
}

