/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.tinylog.core.LogEntry;
import org.tinylog.writers.AbstractFormatPatternWriter;
import org.tinylog.writers.raw.ByteArrayWriter;

public final class FileWriter
extends AbstractFormatPatternWriter {
    private final Charset charset;
    private final ByteArrayWriter writer;

    public FileWriter() throws IOException {
        this(Collections.emptyMap());
    }

    public FileWriter(Map<String, String> properties) throws IOException {
        super(properties);
        String fileName = this.getFileName();
        boolean append = this.getBooleanValue("append");
        boolean buffered = this.getBooleanValue("buffered");
        boolean writingThread = this.getBooleanValue("writingthread");
        this.charset = this.getCharset();
        this.writer = FileWriter.createByteArrayWriter(fileName, append, buffered, !writingThread, false, this.charset);
    }

    @Override
    public void write(LogEntry logEntry) throws IOException {
        byte[] data = this.render(logEntry).getBytes(this.charset);
        this.writer.write(data, 0, data.length);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

