// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func CopyOrigSummaryDataPoint_ValueAtQuantileSlice(dest, src []*otlpmetrics.SummaryDataPoint_ValueAtQuantile) []*otlpmetrics.SummaryDataPoint_ValueAtQuantile {
	var newDest []*otlpmetrics.SummaryDataPoint_ValueAtQuantile
	if cap(dest) < len(src) {
		newDest = make([]*otlpmetrics.SummaryDataPoint_ValueAtQuantile, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigSummaryDataPoint_ValueAtQuantile()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigSummaryDataPoint_ValueAtQuantile(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigSummaryDataPoint_ValueAtQuantile()
		}
	}
	for i := range src {
		CopyOrigSummaryDataPoint_ValueAtQuantile(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestSummaryDataPoint_ValueAtQuantileSlice() []*otlpmetrics.SummaryDataPoint_ValueAtQuantile {
	orig := make([]*otlpmetrics.SummaryDataPoint_ValueAtQuantile, 5)
	orig[0] = NewOrigSummaryDataPoint_ValueAtQuantile()
	orig[1] = GenTestOrigSummaryDataPoint_ValueAtQuantile()
	orig[2] = NewOrigSummaryDataPoint_ValueAtQuantile()
	orig[3] = GenTestOrigSummaryDataPoint_ValueAtQuantile()
	orig[4] = NewOrigSummaryDataPoint_ValueAtQuantile()
	return orig
}
