// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package rolesanywhereiface provides an interface to enable mocking the IAM Roles Anywhere service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package rolesanywhereiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/rolesanywhere"
)

// RolesAnywhereAPI provides an interface to enable mocking the
// rolesanywhere.RolesAnywhere service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// IAM Roles Anywhere.
//	func myFunc(svc rolesanywhereiface.RolesAnywhereAPI) bool {
//	    // Make svc.CreateProfile request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := rolesanywhere.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockRolesAnywhereClient struct {
//	    rolesanywhereiface.RolesAnywhereAPI
//	}
//	func (m *mockRolesAnywhereClient) CreateProfile(input *rolesanywhere.CreateProfileInput) (*rolesanywhere.CreateProfileOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockRolesAnywhereClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type RolesAnywhereAPI interface {
	CreateProfile(*rolesanywhere.CreateProfileInput) (*rolesanywhere.CreateProfileOutput, error)
	CreateProfileWithContext(aws.Context, *rolesanywhere.CreateProfileInput, ...request.Option) (*rolesanywhere.CreateProfileOutput, error)
	CreateProfileRequest(*rolesanywhere.CreateProfileInput) (*request.Request, *rolesanywhere.CreateProfileOutput)

	CreateTrustAnchor(*rolesanywhere.CreateTrustAnchorInput) (*rolesanywhere.CreateTrustAnchorOutput, error)
	CreateTrustAnchorWithContext(aws.Context, *rolesanywhere.CreateTrustAnchorInput, ...request.Option) (*rolesanywhere.CreateTrustAnchorOutput, error)
	CreateTrustAnchorRequest(*rolesanywhere.CreateTrustAnchorInput) (*request.Request, *rolesanywhere.CreateTrustAnchorOutput)

	DeleteCrl(*rolesanywhere.DeleteCrlInput) (*rolesanywhere.DeleteCrlOutput, error)
	DeleteCrlWithContext(aws.Context, *rolesanywhere.DeleteCrlInput, ...request.Option) (*rolesanywhere.DeleteCrlOutput, error)
	DeleteCrlRequest(*rolesanywhere.DeleteCrlInput) (*request.Request, *rolesanywhere.DeleteCrlOutput)

	DeleteProfile(*rolesanywhere.DeleteProfileInput) (*rolesanywhere.DeleteProfileOutput, error)
	DeleteProfileWithContext(aws.Context, *rolesanywhere.DeleteProfileInput, ...request.Option) (*rolesanywhere.DeleteProfileOutput, error)
	DeleteProfileRequest(*rolesanywhere.DeleteProfileInput) (*request.Request, *rolesanywhere.DeleteProfileOutput)

	DeleteTrustAnchor(*rolesanywhere.DeleteTrustAnchorInput) (*rolesanywhere.DeleteTrustAnchorOutput, error)
	DeleteTrustAnchorWithContext(aws.Context, *rolesanywhere.DeleteTrustAnchorInput, ...request.Option) (*rolesanywhere.DeleteTrustAnchorOutput, error)
	DeleteTrustAnchorRequest(*rolesanywhere.DeleteTrustAnchorInput) (*request.Request, *rolesanywhere.DeleteTrustAnchorOutput)

	DisableCrl(*rolesanywhere.DisableCrlInput) (*rolesanywhere.DisableCrlOutput, error)
	DisableCrlWithContext(aws.Context, *rolesanywhere.DisableCrlInput, ...request.Option) (*rolesanywhere.DisableCrlOutput, error)
	DisableCrlRequest(*rolesanywhere.DisableCrlInput) (*request.Request, *rolesanywhere.DisableCrlOutput)

	DisableProfile(*rolesanywhere.DisableProfileInput) (*rolesanywhere.DisableProfileOutput, error)
	DisableProfileWithContext(aws.Context, *rolesanywhere.DisableProfileInput, ...request.Option) (*rolesanywhere.DisableProfileOutput, error)
	DisableProfileRequest(*rolesanywhere.DisableProfileInput) (*request.Request, *rolesanywhere.DisableProfileOutput)

	DisableTrustAnchor(*rolesanywhere.DisableTrustAnchorInput) (*rolesanywhere.DisableTrustAnchorOutput, error)
	DisableTrustAnchorWithContext(aws.Context, *rolesanywhere.DisableTrustAnchorInput, ...request.Option) (*rolesanywhere.DisableTrustAnchorOutput, error)
	DisableTrustAnchorRequest(*rolesanywhere.DisableTrustAnchorInput) (*request.Request, *rolesanywhere.DisableTrustAnchorOutput)

	EnableCrl(*rolesanywhere.EnableCrlInput) (*rolesanywhere.EnableCrlOutput, error)
	EnableCrlWithContext(aws.Context, *rolesanywhere.EnableCrlInput, ...request.Option) (*rolesanywhere.EnableCrlOutput, error)
	EnableCrlRequest(*rolesanywhere.EnableCrlInput) (*request.Request, *rolesanywhere.EnableCrlOutput)

	EnableProfile(*rolesanywhere.EnableProfileInput) (*rolesanywhere.EnableProfileOutput, error)
	EnableProfileWithContext(aws.Context, *rolesanywhere.EnableProfileInput, ...request.Option) (*rolesanywhere.EnableProfileOutput, error)
	EnableProfileRequest(*rolesanywhere.EnableProfileInput) (*request.Request, *rolesanywhere.EnableProfileOutput)

	EnableTrustAnchor(*rolesanywhere.EnableTrustAnchorInput) (*rolesanywhere.EnableTrustAnchorOutput, error)
	EnableTrustAnchorWithContext(aws.Context, *rolesanywhere.EnableTrustAnchorInput, ...request.Option) (*rolesanywhere.EnableTrustAnchorOutput, error)
	EnableTrustAnchorRequest(*rolesanywhere.EnableTrustAnchorInput) (*request.Request, *rolesanywhere.EnableTrustAnchorOutput)

	GetCrl(*rolesanywhere.GetCrlInput) (*rolesanywhere.GetCrlOutput, error)
	GetCrlWithContext(aws.Context, *rolesanywhere.GetCrlInput, ...request.Option) (*rolesanywhere.GetCrlOutput, error)
	GetCrlRequest(*rolesanywhere.GetCrlInput) (*request.Request, *rolesanywhere.GetCrlOutput)

	GetProfile(*rolesanywhere.GetProfileInput) (*rolesanywhere.GetProfileOutput, error)
	GetProfileWithContext(aws.Context, *rolesanywhere.GetProfileInput, ...request.Option) (*rolesanywhere.GetProfileOutput, error)
	GetProfileRequest(*rolesanywhere.GetProfileInput) (*request.Request, *rolesanywhere.GetProfileOutput)

	GetSubject(*rolesanywhere.GetSubjectInput) (*rolesanywhere.GetSubjectOutput, error)
	GetSubjectWithContext(aws.Context, *rolesanywhere.GetSubjectInput, ...request.Option) (*rolesanywhere.GetSubjectOutput, error)
	GetSubjectRequest(*rolesanywhere.GetSubjectInput) (*request.Request, *rolesanywhere.GetSubjectOutput)

	GetTrustAnchor(*rolesanywhere.GetTrustAnchorInput) (*rolesanywhere.GetTrustAnchorOutput, error)
	GetTrustAnchorWithContext(aws.Context, *rolesanywhere.GetTrustAnchorInput, ...request.Option) (*rolesanywhere.GetTrustAnchorOutput, error)
	GetTrustAnchorRequest(*rolesanywhere.GetTrustAnchorInput) (*request.Request, *rolesanywhere.GetTrustAnchorOutput)

	ImportCrl(*rolesanywhere.ImportCrlInput) (*rolesanywhere.ImportCrlOutput, error)
	ImportCrlWithContext(aws.Context, *rolesanywhere.ImportCrlInput, ...request.Option) (*rolesanywhere.ImportCrlOutput, error)
	ImportCrlRequest(*rolesanywhere.ImportCrlInput) (*request.Request, *rolesanywhere.ImportCrlOutput)

	ListCrls(*rolesanywhere.ListCrlsInput) (*rolesanywhere.ListCrlsOutput, error)
	ListCrlsWithContext(aws.Context, *rolesanywhere.ListCrlsInput, ...request.Option) (*rolesanywhere.ListCrlsOutput, error)
	ListCrlsRequest(*rolesanywhere.ListCrlsInput) (*request.Request, *rolesanywhere.ListCrlsOutput)

	ListCrlsPages(*rolesanywhere.ListCrlsInput, func(*rolesanywhere.ListCrlsOutput, bool) bool) error
	ListCrlsPagesWithContext(aws.Context, *rolesanywhere.ListCrlsInput, func(*rolesanywhere.ListCrlsOutput, bool) bool, ...request.Option) error

	ListProfiles(*rolesanywhere.ListProfilesInput) (*rolesanywhere.ListProfilesOutput, error)
	ListProfilesWithContext(aws.Context, *rolesanywhere.ListProfilesInput, ...request.Option) (*rolesanywhere.ListProfilesOutput, error)
	ListProfilesRequest(*rolesanywhere.ListProfilesInput) (*request.Request, *rolesanywhere.ListProfilesOutput)

	ListProfilesPages(*rolesanywhere.ListProfilesInput, func(*rolesanywhere.ListProfilesOutput, bool) bool) error
	ListProfilesPagesWithContext(aws.Context, *rolesanywhere.ListProfilesInput, func(*rolesanywhere.ListProfilesOutput, bool) bool, ...request.Option) error

	ListSubjects(*rolesanywhere.ListSubjectsInput) (*rolesanywhere.ListSubjectsOutput, error)
	ListSubjectsWithContext(aws.Context, *rolesanywhere.ListSubjectsInput, ...request.Option) (*rolesanywhere.ListSubjectsOutput, error)
	ListSubjectsRequest(*rolesanywhere.ListSubjectsInput) (*request.Request, *rolesanywhere.ListSubjectsOutput)

	ListSubjectsPages(*rolesanywhere.ListSubjectsInput, func(*rolesanywhere.ListSubjectsOutput, bool) bool) error
	ListSubjectsPagesWithContext(aws.Context, *rolesanywhere.ListSubjectsInput, func(*rolesanywhere.ListSubjectsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*rolesanywhere.ListTagsForResourceInput) (*rolesanywhere.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *rolesanywhere.ListTagsForResourceInput, ...request.Option) (*rolesanywhere.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*rolesanywhere.ListTagsForResourceInput) (*request.Request, *rolesanywhere.ListTagsForResourceOutput)

	ListTrustAnchors(*rolesanywhere.ListTrustAnchorsInput) (*rolesanywhere.ListTrustAnchorsOutput, error)
	ListTrustAnchorsWithContext(aws.Context, *rolesanywhere.ListTrustAnchorsInput, ...request.Option) (*rolesanywhere.ListTrustAnchorsOutput, error)
	ListTrustAnchorsRequest(*rolesanywhere.ListTrustAnchorsInput) (*request.Request, *rolesanywhere.ListTrustAnchorsOutput)

	ListTrustAnchorsPages(*rolesanywhere.ListTrustAnchorsInput, func(*rolesanywhere.ListTrustAnchorsOutput, bool) bool) error
	ListTrustAnchorsPagesWithContext(aws.Context, *rolesanywhere.ListTrustAnchorsInput, func(*rolesanywhere.ListTrustAnchorsOutput, bool) bool, ...request.Option) error

	TagResource(*rolesanywhere.TagResourceInput) (*rolesanywhere.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *rolesanywhere.TagResourceInput, ...request.Option) (*rolesanywhere.TagResourceOutput, error)
	TagResourceRequest(*rolesanywhere.TagResourceInput) (*request.Request, *rolesanywhere.TagResourceOutput)

	UntagResource(*rolesanywhere.UntagResourceInput) (*rolesanywhere.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *rolesanywhere.UntagResourceInput, ...request.Option) (*rolesanywhere.UntagResourceOutput, error)
	UntagResourceRequest(*rolesanywhere.UntagResourceInput) (*request.Request, *rolesanywhere.UntagResourceOutput)

	UpdateCrl(*rolesanywhere.UpdateCrlInput) (*rolesanywhere.UpdateCrlOutput, error)
	UpdateCrlWithContext(aws.Context, *rolesanywhere.UpdateCrlInput, ...request.Option) (*rolesanywhere.UpdateCrlOutput, error)
	UpdateCrlRequest(*rolesanywhere.UpdateCrlInput) (*request.Request, *rolesanywhere.UpdateCrlOutput)

	UpdateProfile(*rolesanywhere.UpdateProfileInput) (*rolesanywhere.UpdateProfileOutput, error)
	UpdateProfileWithContext(aws.Context, *rolesanywhere.UpdateProfileInput, ...request.Option) (*rolesanywhere.UpdateProfileOutput, error)
	UpdateProfileRequest(*rolesanywhere.UpdateProfileInput) (*request.Request, *rolesanywhere.UpdateProfileOutput)

	UpdateTrustAnchor(*rolesanywhere.UpdateTrustAnchorInput) (*rolesanywhere.UpdateTrustAnchorOutput, error)
	UpdateTrustAnchorWithContext(aws.Context, *rolesanywhere.UpdateTrustAnchorInput, ...request.Option) (*rolesanywhere.UpdateTrustAnchorOutput, error)
	UpdateTrustAnchorRequest(*rolesanywhere.UpdateTrustAnchorInput) (*request.Request, *rolesanywhere.UpdateTrustAnchorOutput)
}

var _ RolesAnywhereAPI = (*rolesanywhere.RolesAnywhere)(nil)
