package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TagLiveResources invokes the live.TagLiveResources API synchronously
func (client *Client) TagLiveResources(request *TagLiveResourcesRequest) (response *TagLiveResourcesResponse, err error) {
	response = CreateTagLiveResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// TagLiveResourcesWithChan invokes the live.TagLiveResources API asynchronously
func (client *Client) TagLiveResourcesWithChan(request *TagLiveResourcesRequest) (<-chan *TagLiveResourcesResponse, <-chan error) {
	responseChan := make(chan *TagLiveResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TagLiveResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TagLiveResourcesWithCallback invokes the live.TagLiveResources API asynchronously
func (client *Client) TagLiveResourcesWithCallback(request *TagLiveResourcesRequest, callback func(response *TagLiveResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TagLiveResourcesResponse
		var err error
		defer close(result)
		response, err = client.TagLiveResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TagLiveResourcesRequest is the request struct for api TagLiveResources
type TagLiveResourcesRequest struct {
	*requests.RpcRequest
	Tag          *[]TagLiveResourcesTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceId   *[]string              `position:"Query" name:"ResourceId"  type:"Repeated"`
	OwnerId      requests.Integer       `position:"Query" name:"OwnerId"`
	ResourceType string                 `position:"Query" name:"ResourceType"`
}

// TagLiveResourcesTag is a repeated param struct in TagLiveResourcesRequest
type TagLiveResourcesTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// TagLiveResourcesResponse is the response struct for api TagLiveResources
type TagLiveResourcesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateTagLiveResourcesRequest creates a request to invoke TagLiveResources API
func CreateTagLiveResourcesRequest() (request *TagLiveResourcesRequest) {
	request = &TagLiveResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "TagLiveResources", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTagLiveResourcesResponse creates a response to parse from TagLiveResources response
func CreateTagLiveResourcesResponse() (response *TagLiveResourcesResponse) {
	response = &TagLiveResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
