package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateDeviceNameListURL invokes the iot.GenerateDeviceNameListURL API synchronously
func (client *Client) GenerateDeviceNameListURL(request *GenerateDeviceNameListURLRequest) (response *GenerateDeviceNameListURLResponse, err error) {
	response = CreateGenerateDeviceNameListURLResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateDeviceNameListURLWithChan invokes the iot.GenerateDeviceNameListURL API asynchronously
func (client *Client) GenerateDeviceNameListURLWithChan(request *GenerateDeviceNameListURLRequest) (<-chan *GenerateDeviceNameListURLResponse, <-chan error) {
	responseChan := make(chan *GenerateDeviceNameListURLResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateDeviceNameListURL(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateDeviceNameListURLWithCallback invokes the iot.GenerateDeviceNameListURL API asynchronously
func (client *Client) GenerateDeviceNameListURLWithCallback(request *GenerateDeviceNameListURLRequest, callback func(response *GenerateDeviceNameListURLResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateDeviceNameListURLResponse
		var err error
		defer close(result)
		response, err = client.GenerateDeviceNameListURL(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateDeviceNameListURLRequest is the request struct for api GenerateDeviceNameListURL
type GenerateDeviceNameListURLRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// GenerateDeviceNameListURLResponse is the response struct for api GenerateDeviceNameListURL
type GenerateDeviceNameListURLResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateGenerateDeviceNameListURLRequest creates a request to invoke GenerateDeviceNameListURL API
func CreateGenerateDeviceNameListURLRequest() (request *GenerateDeviceNameListURLRequest) {
	request = &GenerateDeviceNameListURLRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GenerateDeviceNameListURL", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateDeviceNameListURLResponse creates a response to parse from GenerateDeviceNameListURL response
func CreateGenerateDeviceNameListURLResponse() (response *GenerateDeviceNameListURLResponse) {
	response = &GenerateDeviceNameListURLResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
