package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteVnInstance invokes the cloudcallcenter.DeleteVnInstance API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletevninstance.html
func (client *Client) DeleteVnInstance(request *DeleteVnInstanceRequest) (response *DeleteVnInstanceResponse, err error) {
	response = CreateDeleteVnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteVnInstanceWithChan invokes the cloudcallcenter.DeleteVnInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletevninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteVnInstanceWithChan(request *DeleteVnInstanceRequest) (<-chan *DeleteVnInstanceResponse, <-chan error) {
	responseChan := make(chan *DeleteVnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteVnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteVnInstanceWithCallback invokes the cloudcallcenter.DeleteVnInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletevninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteVnInstanceWithCallback(request *DeleteVnInstanceRequest, callback func(response *DeleteVnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteVnInstanceResponse
		var err error
		defer close(result)
		response, err = client.DeleteVnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteVnInstanceRequest is the request struct for api DeleteVnInstance
type DeleteVnInstanceRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteVnInstanceResponse is the response struct for api DeleteVnInstance
type DeleteVnInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteVnInstanceRequest creates a request to invoke DeleteVnInstance API
func CreateDeleteVnInstanceRequest() (request *DeleteVnInstanceRequest) {
	request = &DeleteVnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DeleteVnInstance", "", "")
	request.Method = requests.GET
	return
}

// CreateDeleteVnInstanceResponse creates a response to parse from DeleteVnInstance response
func CreateDeleteVnInstanceResponse() (response *DeleteVnInstanceResponse) {
	response = &DeleteVnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
