package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// LaunchAuthentication invokes the ccc.LaunchAuthentication API synchronously
func (client *Client) LaunchAuthentication(request *LaunchAuthenticationRequest) (response *LaunchAuthenticationResponse, err error) {
	response = CreateLaunchAuthenticationResponse()
	err = client.DoAction(request, response)
	return
}

// LaunchAuthenticationWithChan invokes the ccc.LaunchAuthentication API asynchronously
func (client *Client) LaunchAuthenticationWithChan(request *LaunchAuthenticationRequest) (<-chan *LaunchAuthenticationResponse, <-chan error) {
	responseChan := make(chan *LaunchAuthenticationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.LaunchAuthentication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// LaunchAuthenticationWithCallback invokes the ccc.LaunchAuthentication API asynchronously
func (client *Client) LaunchAuthenticationWithCallback(request *LaunchAuthenticationRequest, callback func(response *LaunchAuthenticationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *LaunchAuthenticationResponse
		var err error
		defer close(result)
		response, err = client.LaunchAuthentication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// LaunchAuthenticationRequest is the request struct for api LaunchAuthentication
type LaunchAuthenticationRequest struct {
	*requests.RpcRequest
	ContactFlowId string `position:"Query" name:"ContactFlowId"`
	UserId        string `position:"Query" name:"UserId"`
	DeviceId      string `position:"Query" name:"DeviceId"`
	JobId         string `position:"Query" name:"JobId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
}

// LaunchAuthenticationResponse is the response struct for api LaunchAuthentication
type LaunchAuthenticationResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateLaunchAuthenticationRequest creates a request to invoke LaunchAuthentication API
func CreateLaunchAuthenticationRequest() (request *LaunchAuthenticationRequest) {
	request = &LaunchAuthenticationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "LaunchAuthentication", "", "")
	request.Method = requests.POST
	return
}

// CreateLaunchAuthenticationResponse creates a response to parse from LaunchAuthentication response
func CreateLaunchAuthenticationResponse() (response *LaunchAuthenticationResponse) {
	response = &LaunchAuthenticationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
