package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDnsCacheDomain invokes the alidns.AddDnsCacheDomain API synchronously
func (client *Client) AddDnsCacheDomain(request *AddDnsCacheDomainRequest) (response *AddDnsCacheDomainResponse, err error) {
	response = CreateAddDnsCacheDomainResponse()
	err = client.DoAction(request, response)
	return
}

// AddDnsCacheDomainWithChan invokes the alidns.AddDnsCacheDomain API asynchronously
func (client *Client) AddDnsCacheDomainWithChan(request *AddDnsCacheDomainRequest) (<-chan *AddDnsCacheDomainResponse, <-chan error) {
	responseChan := make(chan *AddDnsCacheDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDnsCacheDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDnsCacheDomainWithCallback invokes the alidns.AddDnsCacheDomain API asynchronously
func (client *Client) AddDnsCacheDomainWithCallback(request *AddDnsCacheDomainRequest, callback func(response *AddDnsCacheDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDnsCacheDomainResponse
		var err error
		defer close(result)
		response, err = client.AddDnsCacheDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDnsCacheDomainRequest is the request struct for api AddDnsCacheDomain
type AddDnsCacheDomainRequest struct {
	*requests.RpcRequest
	Remark          string                              `position:"Query" name:"Remark"`
	SourceProtocol  string                              `position:"Query" name:"SourceProtocol"`
	Lang            string                              `position:"Query" name:"Lang"`
	DomainName      string                              `position:"Query" name:"DomainName"`
	CacheTtlMax     requests.Integer                    `position:"Query" name:"CacheTtlMax"`
	InstanceId      string                              `position:"Query" name:"InstanceId"`
	SourceEdns      string                              `position:"Query" name:"SourceEdns"`
	UserClientIp    string                              `position:"Query" name:"UserClientIp"`
	CacheTtlMin     requests.Integer                    `position:"Query" name:"CacheTtlMin"`
	SourceDnsServer *[]AddDnsCacheDomainSourceDnsServer `position:"Query" name:"SourceDnsServer"  type:"Repeated"`
}

// AddDnsCacheDomainSourceDnsServer is a repeated param struct in AddDnsCacheDomainRequest
type AddDnsCacheDomainSourceDnsServer struct {
	Port string `name:"Port"`
	Host string `name:"Host"`
}

// AddDnsCacheDomainResponse is the response struct for api AddDnsCacheDomain
type AddDnsCacheDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddDnsCacheDomainRequest creates a request to invoke AddDnsCacheDomain API
func CreateAddDnsCacheDomainRequest() (request *AddDnsCacheDomainRequest) {
	request = &AddDnsCacheDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "AddDnsCacheDomain", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddDnsCacheDomainResponse creates a response to parse from AddDnsCacheDomain response
func CreateAddDnsCacheDomainResponse() (response *AddDnsCacheDomainResponse) {
	response = &AddDnsCacheDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
