// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct InvokeModelWithResponseStreamInput {
    /// <p>The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You must provide the body in JSON format. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the Bedrock User Guide.</p>
    pub body: ::std::option::Option<::aws_smithy_types::Blob>,
    /// <p>The MIME type of the input data in the request. You must specify <code>application/json</code>.</p>
    pub content_type: ::std::option::Option<::std::string::String>,
    /// <p>The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.</p>
    pub accept: ::std::option::Option<::std::string::String>,
    /// <p>The unique identifier of the model to invoke to run inference.</p>
    /// <p>The <code>modelId</code> to provide depends on the type of model or throughput that you use:</p>
    /// <ul>
    /// <li>
    /// <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile IDs, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a custom model, specify the ARN of the custom model deployment (for on-demand inference) or the ARN of your provisioned model (for Provisioned Throughput). For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.</p></li>
    /// </ul>
    pub model_id: ::std::option::Option<::std::string::String>,
    /// <p>Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.</p>
    pub trace: ::std::option::Option<crate::types::Trace>,
    /// <p>The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail is applied to the invocation.</p>
    /// <p>An error is thrown in the following situations.</p>
    /// <ul>
    /// <li>
    /// <p>You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in the request body.</p></li>
    /// <li>
    /// <p>You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.</p></li>
    /// <li>
    /// <p>You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.</p></li>
    /// </ul>
    pub guardrail_identifier: ::std::option::Option<::std::string::String>,
    /// <p>The version number for the guardrail. The value can also be <code>DRAFT</code>.</p>
    pub guardrail_version: ::std::option::Option<::std::string::String>,
    /// <p>Model performance settings for the request.</p>
    pub performance_config_latency: ::std::option::Option<crate::types::PerformanceConfigLatency>,
}
impl InvokeModelWithResponseStreamInput {
    /// <p>The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You must provide the body in JSON format. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the Bedrock User Guide.</p>
    pub fn body(&self) -> ::std::option::Option<&::aws_smithy_types::Blob> {
        self.body.as_ref()
    }
    /// <p>The MIME type of the input data in the request. You must specify <code>application/json</code>.</p>
    pub fn content_type(&self) -> ::std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.</p>
    pub fn accept(&self) -> ::std::option::Option<&str> {
        self.accept.as_deref()
    }
    /// <p>The unique identifier of the model to invoke to run inference.</p>
    /// <p>The <code>modelId</code> to provide depends on the type of model or throughput that you use:</p>
    /// <ul>
    /// <li>
    /// <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile IDs, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a custom model, specify the ARN of the custom model deployment (for on-demand inference) or the ARN of your provisioned model (for Provisioned Throughput). For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.</p></li>
    /// </ul>
    pub fn model_id(&self) -> ::std::option::Option<&str> {
        self.model_id.as_deref()
    }
    /// <p>Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.</p>
    pub fn trace(&self) -> ::std::option::Option<&crate::types::Trace> {
        self.trace.as_ref()
    }
    /// <p>The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail is applied to the invocation.</p>
    /// <p>An error is thrown in the following situations.</p>
    /// <ul>
    /// <li>
    /// <p>You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in the request body.</p></li>
    /// <li>
    /// <p>You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.</p></li>
    /// <li>
    /// <p>You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.</p></li>
    /// </ul>
    pub fn guardrail_identifier(&self) -> ::std::option::Option<&str> {
        self.guardrail_identifier.as_deref()
    }
    /// <p>The version number for the guardrail. The value can also be <code>DRAFT</code>.</p>
    pub fn guardrail_version(&self) -> ::std::option::Option<&str> {
        self.guardrail_version.as_deref()
    }
    /// <p>Model performance settings for the request.</p>
    pub fn performance_config_latency(&self) -> ::std::option::Option<&crate::types::PerformanceConfigLatency> {
        self.performance_config_latency.as_ref()
    }
}
impl ::std::fmt::Debug for InvokeModelWithResponseStreamInput {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeModelWithResponseStreamInput");
        formatter.field("body", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.field("accept", &self.accept);
        formatter.field("model_id", &self.model_id);
        formatter.field("trace", &self.trace);
        formatter.field("guardrail_identifier", &self.guardrail_identifier);
        formatter.field("guardrail_version", &self.guardrail_version);
        formatter.field("performance_config_latency", &self.performance_config_latency);
        formatter.finish()
    }
}
impl InvokeModelWithResponseStreamInput {
    /// Creates a new builder-style object to manufacture [`InvokeModelWithResponseStreamInput`](crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamInput).
    pub fn builder() -> crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamInputBuilder {
        crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamInputBuilder::default()
    }
}

/// A builder for [`InvokeModelWithResponseStreamInput`](crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct InvokeModelWithResponseStreamInputBuilder {
    pub(crate) body: ::std::option::Option<::aws_smithy_types::Blob>,
    pub(crate) content_type: ::std::option::Option<::std::string::String>,
    pub(crate) accept: ::std::option::Option<::std::string::String>,
    pub(crate) model_id: ::std::option::Option<::std::string::String>,
    pub(crate) trace: ::std::option::Option<crate::types::Trace>,
    pub(crate) guardrail_identifier: ::std::option::Option<::std::string::String>,
    pub(crate) guardrail_version: ::std::option::Option<::std::string::String>,
    pub(crate) performance_config_latency: ::std::option::Option<crate::types::PerformanceConfigLatency>,
}
impl InvokeModelWithResponseStreamInputBuilder {
    /// <p>The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You must provide the body in JSON format. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the Bedrock User Guide.</p>
    pub fn body(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.body = ::std::option::Option::Some(input);
        self
    }
    /// <p>The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You must provide the body in JSON format. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the Bedrock User Guide.</p>
    pub fn set_body(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.body = input;
        self
    }
    /// <p>The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You must provide the body in JSON format. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the Bedrock User Guide.</p>
    pub fn get_body(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.body
    }
    /// <p>The MIME type of the input data in the request. You must specify <code>application/json</code>.</p>
    pub fn content_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The MIME type of the input data in the request. You must specify <code>application/json</code>.</p>
    pub fn set_content_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_type = input;
        self
    }
    /// <p>The MIME type of the input data in the request. You must specify <code>application/json</code>.</p>
    pub fn get_content_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_type
    }
    /// <p>The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.</p>
    pub fn accept(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.accept = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.</p>
    pub fn set_accept(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.accept = input;
        self
    }
    /// <p>The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.</p>
    pub fn get_accept(&self) -> &::std::option::Option<::std::string::String> {
        &self.accept
    }
    /// <p>The unique identifier of the model to invoke to run inference.</p>
    /// <p>The <code>modelId</code> to provide depends on the type of model or throughput that you use:</p>
    /// <ul>
    /// <li>
    /// <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile IDs, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a custom model, specify the ARN of the custom model deployment (for on-demand inference) or the ARN of your provisioned model (for Provisioned Throughput). For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.</p></li>
    /// </ul>
    /// This field is required.
    pub fn model_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.model_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The unique identifier of the model to invoke to run inference.</p>
    /// <p>The <code>modelId</code> to provide depends on the type of model or throughput that you use:</p>
    /// <ul>
    /// <li>
    /// <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile IDs, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a custom model, specify the ARN of the custom model deployment (for on-demand inference) or the ARN of your provisioned model (for Provisioned Throughput). For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.</p></li>
    /// </ul>
    pub fn set_model_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.model_id = input;
        self
    }
    /// <p>The unique identifier of the model to invoke to run inference.</p>
    /// <p>The <code>modelId</code> to provide depends on the type of model or throughput that you use:</p>
    /// <ul>
    /// <li>
    /// <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile IDs, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a custom model, specify the ARN of the custom model deployment (for on-demand inference) or the ARN of your provisioned model (for Provisioned Throughput). For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.</p></li>
    /// </ul>
    pub fn get_model_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.model_id
    }
    /// <p>Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.</p>
    pub fn trace(mut self, input: crate::types::Trace) -> Self {
        self.trace = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.</p>
    pub fn set_trace(mut self, input: ::std::option::Option<crate::types::Trace>) -> Self {
        self.trace = input;
        self
    }
    /// <p>Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.</p>
    pub fn get_trace(&self) -> &::std::option::Option<crate::types::Trace> {
        &self.trace
    }
    /// <p>The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail is applied to the invocation.</p>
    /// <p>An error is thrown in the following situations.</p>
    /// <ul>
    /// <li>
    /// <p>You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in the request body.</p></li>
    /// <li>
    /// <p>You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.</p></li>
    /// <li>
    /// <p>You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.</p></li>
    /// </ul>
    pub fn guardrail_identifier(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.guardrail_identifier = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail is applied to the invocation.</p>
    /// <p>An error is thrown in the following situations.</p>
    /// <ul>
    /// <li>
    /// <p>You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in the request body.</p></li>
    /// <li>
    /// <p>You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.</p></li>
    /// <li>
    /// <p>You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.</p></li>
    /// </ul>
    pub fn set_guardrail_identifier(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.guardrail_identifier = input;
        self
    }
    /// <p>The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail is applied to the invocation.</p>
    /// <p>An error is thrown in the following situations.</p>
    /// <ul>
    /// <li>
    /// <p>You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in the request body.</p></li>
    /// <li>
    /// <p>You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.</p></li>
    /// <li>
    /// <p>You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.</p></li>
    /// </ul>
    pub fn get_guardrail_identifier(&self) -> &::std::option::Option<::std::string::String> {
        &self.guardrail_identifier
    }
    /// <p>The version number for the guardrail. The value can also be <code>DRAFT</code>.</p>
    pub fn guardrail_version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.guardrail_version = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The version number for the guardrail. The value can also be <code>DRAFT</code>.</p>
    pub fn set_guardrail_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.guardrail_version = input;
        self
    }
    /// <p>The version number for the guardrail. The value can also be <code>DRAFT</code>.</p>
    pub fn get_guardrail_version(&self) -> &::std::option::Option<::std::string::String> {
        &self.guardrail_version
    }
    /// <p>Model performance settings for the request.</p>
    pub fn performance_config_latency(mut self, input: crate::types::PerformanceConfigLatency) -> Self {
        self.performance_config_latency = ::std::option::Option::Some(input);
        self
    }
    /// <p>Model performance settings for the request.</p>
    pub fn set_performance_config_latency(mut self, input: ::std::option::Option<crate::types::PerformanceConfigLatency>) -> Self {
        self.performance_config_latency = input;
        self
    }
    /// <p>Model performance settings for the request.</p>
    pub fn get_performance_config_latency(&self) -> &::std::option::Option<crate::types::PerformanceConfigLatency> {
        &self.performance_config_latency
    }
    /// Consumes the builder and constructs a [`InvokeModelWithResponseStreamInput`](crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamInput {
            body: self.body,
            content_type: self.content_type,
            accept: self.accept,
            model_id: self.model_id,
            trace: self.trace,
            guardrail_identifier: self.guardrail_identifier,
            guardrail_version: self.guardrail_version,
            performance_config_latency: self.performance_config_latency,
        })
    }
}
impl ::std::fmt::Debug for InvokeModelWithResponseStreamInputBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeModelWithResponseStreamInputBuilder");
        formatter.field("body", &"*** Sensitive Data Redacted ***");
        formatter.field("content_type", &self.content_type);
        formatter.field("accept", &self.accept);
        formatter.field("model_id", &self.model_id);
        formatter.field("trace", &self.trace);
        formatter.field("guardrail_identifier", &self.guardrail_identifier);
        formatter.field("guardrail_version", &self.guardrail_version);
        formatter.field("performance_config_latency", &self.performance_config_latency);
        formatter.finish()
    }
}
