//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-uniform-type-identifiers")]
#[cfg(target_vendor = "apple")]
use objc2_uniform_type_identifiers::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nssavepanel?language=objc)
    #[unsafe(super(NSPanel, NSWindow, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSPanel", feature = "NSResponder", feature = "NSWindow"))]
    pub struct NSSavePanel;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSPanel",
    feature = "NSResponder",
    feature = "NSWindow"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSSavePanel {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSPanel",
    feature = "NSResponder",
    feature = "NSWindow"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSSavePanel {}
);

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSPanel",
    feature = "NSResponder",
    feature = "NSWindow"
))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSSavePanel {}
);

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSPanel",
    feature = "NSResponder",
    feature = "NSWindow"
))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSSavePanel {}
);

#[cfg(all(feature = "NSPanel", feature = "NSResponder", feature = "NSWindow"))]
extern_conformance!(
    unsafe impl NSCoding for NSSavePanel {}
);

#[cfg(all(
    feature = "NSMenu",
    feature = "NSPanel",
    feature = "NSResponder",
    feature = "NSWindow"
))]
extern_conformance!(
    unsafe impl NSMenuItemValidation for NSSavePanel {}
);

#[cfg(all(feature = "NSPanel", feature = "NSResponder", feature = "NSWindow"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSSavePanel {}
);

#[cfg(all(
    feature = "NSPanel",
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSWindow"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSSavePanel {}
);

#[cfg(all(
    feature = "NSPanel",
    feature = "NSResponder",
    feature = "NSUserInterfaceValidation",
    feature = "NSWindow"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceValidations for NSSavePanel {}
);

#[cfg(all(feature = "NSPanel", feature = "NSResponder", feature = "NSWindow"))]
impl NSSavePanel {
    extern_methods!(
        /// Creates a new instance of the NSSavePanel. This class is not a singleton.
        #[unsafe(method(savePanel))]
        #[unsafe(method_family = none)]
        pub unsafe fn savePanel(mtm: MainThreadMarker) -> Retained<NSSavePanel>;

        /// `NSSavePanel`: Returns the URL to save the file at. A file may already exist at `url` if the user choose to overwrite it.
        /// `NSOpenPanel`: Returns the single filename selected by the user. Note: if -allowsMultipleSelection is set, you should use the -URLs on NSOpenPanel instead.
        #[unsafe(method(URL))]
        #[unsafe(method_family = none)]
        pub unsafe fn URL(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        /// Sets and returns the identifier.
        ///
        /// The panel's current state such as the root directory and the current directory are saved and restored relative to the identifier.
        /// - Note: When the identifier is changed, the properties that depend on the identifier are updated from user defaults. Properties that have a null value in user defaults are not changed (and keep their existing value).
        /// - Note: Can only be set during the configuration phase.
        #[unsafe(method(identifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn identifier(&self) -> Option<Retained<NSUserInterfaceItemIdentifier>>;

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        /// Setter for [`identifier`][Self::identifier].
        #[unsafe(method(setIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setIdentifier(&self, identifier: Option<&NSUserInterfaceItemIdentifier>);

        /// `NSSavePanel`/`NSOpenPanel`: Sets and returns the directory that is displayed. Set to `nil` to display the default directory. This method will not block to resolve the URL, and the directory will asyncronously be set, if required.
        /// - Note: Can only be set during the configuration phase.
        #[unsafe(method(directoryURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn directoryURL(&self) -> Option<Retained<NSURL>>;

        /// Setter for [`directoryURL`][Self::directoryURL].
        #[unsafe(method(setDirectoryURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDirectoryURL(&self, directory_url: Option<&NSURL>);

        #[cfg(feature = "objc2-uniform-type-identifiers")]
        #[cfg(target_vendor = "apple")]
        /// `NSSavePanel`: An array of UTTypes specifying the file types the user can save the file as. Set to `
        /// @
        /// []` to specify that any file type can be used. If no extension is given by the user, the first preferred extension from the array will be used as the extension for the save panel. If the user specifies a type not in the array, and `allowsOtherFileTypes` is `YES`, they will be presented with another dialog when prompted to save. The default value is the empty array.
        /// `NSOpenPanel`: This property determines which files should be enabled in the open panel. Using the deprecated methods to show the open panel (the ones that take a "types:" parameter) will overwrite this value, and should not be used. `allowedContentTypes` can be changed while the panel is running (ie: from an accessory view). This is also known as the "enabled file types". Set to `
        /// @
        /// []` to specify that all files should be enabled.
        #[unsafe(method(allowedContentTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowedContentTypes(&self) -> Retained<NSArray<UTType>>;

        #[cfg(feature = "objc2-uniform-type-identifiers")]
        #[cfg(target_vendor = "apple")]
        /// Setter for [`allowedContentTypes`][Self::allowedContentTypes].
        #[unsafe(method(setAllowedContentTypes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowedContentTypes(&self, allowed_content_types: &NSArray<UTType>);

        /// `NSSavePanel`: Returns a BOOL value that indicates whether the panel allows the user to save files with an extension that is not in the list of `allowedFileTypes`.
        /// `NSOpenPanel`: Not used.
        #[unsafe(method(allowsOtherFileTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsOtherFileTypes(&self) -> bool;

        /// Setter for [`allowsOtherFileTypes`][Self::allowsOtherFileTypes].
        #[unsafe(method(setAllowsOtherFileTypes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsOtherFileTypes(&self, allows_other_file_types: bool);

        #[cfg(feature = "objc2-uniform-type-identifiers")]
        #[cfg(target_vendor = "apple")]
        /// `NSSavePanel`:The current type. If set to `nil`, resets to the first allowed content type. Returns `nil` if `allowedContentTypes` is empty.
        /// `NSOpenPanel`: Not used.
        /// - Note: Asserts that `currentContentType` conforms to `UTTypeData` or `UTTypeDirectory`.
        #[unsafe(method(currentContentType))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentContentType(&self) -> Option<Retained<UTType>>;

        #[cfg(feature = "objc2-uniform-type-identifiers")]
        #[cfg(target_vendor = "apple")]
        /// Setter for [`currentContentType`][Self::currentContentType].
        #[unsafe(method(setCurrentContentType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCurrentContentType(&self, current_content_type: Option<&UTType>);

        #[cfg(feature = "NSView")]
        /// Sets and returns the accessory view shown in the panel. For applications that link on SnowLeopard and higher, the accessoryView's frame will be observed, and any changes the programmer makes to the frame will automatically be reflected in the panel (including animated changes to the frame height).
        #[unsafe(method(accessoryView))]
        #[unsafe(method_family = none)]
        pub unsafe fn accessoryView(&self) -> Option<Retained<NSView>>;

        #[cfg(feature = "NSView")]
        /// Setter for [`accessoryView`][Self::accessoryView].
        #[unsafe(method(setAccessoryView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAccessoryView(&self, accessory_view: Option<&NSView>);

        /// `NSSavePanel`/`NSOpenPanel`: Sets and returns the delegate.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSOpenSavePanelDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSOpenSavePanelDelegate>>,
        );

        /// `NSSavePanel`: Returns `YES` if the panel is expanded. Defaults to `NO`. Persists in the user defaults.
        /// - Note: Can only be set during the configuration phase.
        /// `NSOpenPanel`: Not used.
        #[unsafe(method(isExpanded))]
        #[unsafe(method_family = none)]
        pub unsafe fn isExpanded(&self) -> bool;

        /// `NSSavePanel`/`NSOpenPanel`: Set to `YES` to show the "New Folder" button. Default is `YES`.
        #[unsafe(method(canCreateDirectories))]
        #[unsafe(method_family = none)]
        pub unsafe fn canCreateDirectories(&self) -> bool;

        /// Setter for [`canCreateDirectories`][Self::canCreateDirectories].
        #[unsafe(method(setCanCreateDirectories:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCanCreateDirectories(&self, can_create_directories: bool);

        /// `NSSavePanel`: Set to `YES` to show the "Hide Extension" menu item.
        /// `NSOpenPanel`: Not used.
        #[unsafe(method(canSelectHiddenExtension))]
        #[unsafe(method_family = none)]
        pub unsafe fn canSelectHiddenExtension(&self) -> bool;

        /// Setter for [`canSelectHiddenExtension`][Self::canSelectHiddenExtension].
        #[unsafe(method(setCanSelectHiddenExtension:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCanSelectHiddenExtension(&self, can_select_hidden_extension: bool);

        /// `NSSavePanel`: Set to `YES` if the filename extension should be hidden. Otherwise, `NO` if the filename extension should be shown. Default is `YES`.
        /// - Note: Can only be set during the configuration phase.
        /// `NSOpenPanel`: Not used.
        #[unsafe(method(isExtensionHidden))]
        #[unsafe(method_family = none)]
        pub unsafe fn isExtensionHidden(&self) -> bool;

        /// Setter for [`isExtensionHidden`][Self::isExtensionHidden].
        #[unsafe(method(setExtensionHidden:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setExtensionHidden(&self, extension_hidden: bool);

        /// `NSSavePanel`/`NSOpenPanel`: If set to `YES`, the user can navigate into file packages as if they were directories. Default is `NO`.
        #[unsafe(method(treatsFilePackagesAsDirectories))]
        #[unsafe(method_family = none)]
        pub unsafe fn treatsFilePackagesAsDirectories(&self) -> bool;

        /// Setter for [`treatsFilePackagesAsDirectories`][Self::treatsFilePackagesAsDirectories].
        #[unsafe(method(setTreatsFilePackagesAsDirectories:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTreatsFilePackagesAsDirectories(
            &self,
            treats_file_packages_as_directories: bool,
        );

        /// `NSSavePanel`/`NSOpenPanel`: Sets the text shown on the Open or Save button. If set to an empty string, it will show a localized "Open" for the NSOpenPanel and "Save" for the NSSavePanel. The default value will be the correct localized prompt for the open or save panel, as appropriate.
        #[unsafe(method(prompt))]
        #[unsafe(method_family = none)]
        pub unsafe fn prompt(&self) -> Retained<NSString>;

        /// Setter for [`prompt`][Self::prompt].
        #[unsafe(method(setPrompt:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPrompt(&self, prompt: Option<&NSString>);

        /// `NSSavePanel`/`NSOpenPanel`: Sets and returns the title for the panel shown at the top of the window.
        /// - Note: The open and save panel does not currently have a titlebar. So the title is not displayed.
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub unsafe fn title(&self) -> Retained<NSString>;

        /// Setter for [`title`][Self::title].
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitle(&self, title: Option<&NSString>);

        /// `NSSavePanel`: Sets and returns the text shown to the left of the "name field". Default value is a localized "Save As:" string.
        /// `NSOpenPanel`: Not used.
        #[unsafe(method(nameFieldLabel))]
        #[unsafe(method_family = none)]
        pub unsafe fn nameFieldLabel(&self) -> Retained<NSString>;

        /// Setter for [`nameFieldLabel`][Self::nameFieldLabel].
        #[unsafe(method(setNameFieldLabel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNameFieldLabel(&self, name_field_label: Option<&NSString>);

        /// `NSSavePanel`: Sets and returns the user-editable file name shown in the name field.
        /// - Note: Calling the deprecated methods that take a "name:" parameter will overwrite any values set before the panel is shown.
        /// - Note: If `[panel isExtensionHidden]` is set to `YES`, the extension will be hidden.
        /// - Note: Can only be set during the configuration phase.
        /// `NSOpenPanel`: Not used.
        #[unsafe(method(nameFieldStringValue))]
        #[unsafe(method_family = none)]
        pub unsafe fn nameFieldStringValue(&self) -> Retained<NSString>;

        /// Setter for [`nameFieldStringValue`][Self::nameFieldStringValue].
        #[unsafe(method(setNameFieldStringValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNameFieldStringValue(&self, name_field_string_value: &NSString);

        /// `NSSavePanel`/`NSOpenPanel`: Sets and returns the message shown under title of the panel.
        #[unsafe(method(message))]
        #[unsafe(method_family = none)]
        pub unsafe fn message(&self) -> Retained<NSString>;

        /// Setter for [`message`][Self::message].
        #[unsafe(method(setMessage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMessage(&self, message: Option<&NSString>);

        /// `NSSavePanel`/`NSOpenPanel`: If `showsHiddenFiles` is set to `YES`, files that are normally hidden from the user are displayed. This method was published in Mac OS 10.6, but has existed since Mac OS 10.4. This property is KVO compliant. The user may invoke the keyboard shortcut (cmd-shift-.) to show or hide hidden files. Any user interface shown in an an accessory view should be updated by using key value observing (KVO) to watch for changes of this property. Alternatively, the user interface can be directly bound to this property. The default value is `NO`.
        #[unsafe(method(showsHiddenFiles))]
        #[unsafe(method_family = none)]
        pub unsafe fn showsHiddenFiles(&self) -> bool;

        /// Setter for [`showsHiddenFiles`][Self::showsHiddenFiles].
        #[unsafe(method(setShowsHiddenFiles:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShowsHiddenFiles(&self, shows_hidden_files: bool);

        /// `NSSavePanel`: Shows or hides the "Tags" field in the receiver. By passing `YES`, you become responsible for setting Tag names on the resulting file after saving is complete. Default is `YES`.
        /// `NSOpenPanel`: Not used.
        #[unsafe(method(showsTagField))]
        #[unsafe(method_family = none)]
        pub unsafe fn showsTagField(&self) -> bool;

        /// Setter for [`showsTagField`][Self::showsTagField].
        #[unsafe(method(setShowsTagField:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShowsTagField(&self, shows_tag_field: bool);

        /// `NSSavePanel`: When -showsTagField returns YES, set any initial Tag names to be displayed, if necessary, prior to displaying the receiver. Also, if the user clicks "Save", take the result of -tagNames, and set them on the resulting file after saving is complete. Tag names are NSStrings, arrays of which can be used directly with the NSURLTagNamesKey API for getting and setting tags on files. Passing `nil` or an empty array to -setTagNames: will result in no initial Tag names appearing in the receiver. When -showsTagField returns YES, -tagNames always returns a non-nil array, and when NO, -tagNames always returns `nil`.
        /// `NSOpenPanel`: Not used.
        #[unsafe(method(tagNames))]
        #[unsafe(method_family = none)]
        pub unsafe fn tagNames(&self) -> Option<Retained<NSArray<NSString>>>;

        /// Setter for [`tagNames`][Self::tagNames].
        #[unsafe(method(setTagNames:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTagNames(&self, tag_names: Option<&NSArray<NSString>>);

        /// `NSSavePanel`: Whether or not to show a control for selecting the type of the saved file.
        /// The control shows the types in `allowedContentTypes`. Default is `NO`.
        /// - Note: If
        /// `allowedContentTypes`is empty, the control is not displayed.
        /// `NSOpenPanel`: Not used.
        #[unsafe(method(showsContentTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn showsContentTypes(&self) -> bool;

        /// Setter for [`showsContentTypes`][Self::showsContentTypes].
        #[unsafe(method(setShowsContentTypes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShowsContentTypes(&self, shows_content_types: bool);

        /// Refreshes the open or save panel's contents.
        #[unsafe(method(validateVisibleColumns))]
        #[unsafe(method_family = none)]
        pub unsafe fn validateVisibleColumns(&self);

        #[unsafe(method(ok:))]
        #[unsafe(method_family = none)]
        pub unsafe fn ok(&self, sender: Option<&AnyObject>);

        #[unsafe(method(cancel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn cancel(&self, sender: Option<&AnyObject>);

        #[cfg(all(feature = "NSApplication", feature = "block2"))]
        /// `NSSavePanel`/`NSOpenPanel`: Presents the panel as a sheet modal to `window` and returns immediately. Configure the panel before calling this method. The completion handler block will be called after the user has closed the panel, however, the open/save panel sheet may still be on screen. If you require the sheet to be offscreen (for example, to show an alert), first call `[savePanel orderOut:nil]` to close it. The `result` will be `NSModalResponseOK`, `NSModalResponseCancel`, or if the panel fails to display, `NSModalResponseAbort`.
        #[unsafe(method(beginSheetModalForWindow:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn beginSheetModalForWindow_completionHandler(
            &self,
            window: &NSWindow,
            handler: &block2::DynBlock<dyn Fn(NSModalResponse)>,
        );

        #[cfg(all(feature = "NSApplication", feature = "block2"))]
        /// `NSSavePanel`/`NSOpenPanel`: Presents the panel as a modeless window and returns immediately. Configure the panel before calling this method. The completion handler block will be called after the user has closed the panel. The `result` will be `NSModalResponseOK`, `NSModalResponseCancel`, or if the panel fails to display, `NSModalResponseAbort`.
        #[unsafe(method(beginWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn beginWithCompletionHandler(
            &self,
            handler: &block2::DynBlock<dyn Fn(NSModalResponse)>,
        );

        #[cfg(feature = "NSApplication")]
        /// `NSSavePanel`/`NSOpenPanel`: Presents the panel as an application modal window. Returns after the user has closed the panel.
        /// - Returns: `NSModalResponseOK`, `NSModalResponseCancel` or if the panel fails to display, `NSModalResponseAbort`.
        #[unsafe(method(runModal))]
        #[unsafe(method_family = none)]
        pub unsafe fn runModal(&self) -> NSModalResponse;
    );
}

/// Methods declared on superclass `NSWindow`.
#[cfg(all(feature = "NSPanel", feature = "NSResponder", feature = "NSWindow"))]
impl NSSavePanel {
    extern_methods!(
        #[cfg(feature = "NSGraphics")]
        #[unsafe(method(initWithContentRect:styleMask:backing:defer:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentRect_styleMask_backing_defer(
            this: Allocated<Self>,
            content_rect: NSRect,
            style: NSWindowStyleMask,
            backing_store_type: NSBackingStoreType,
            flag: bool,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSGraphics", feature = "NSScreen"))]
        #[unsafe(method(initWithContentRect:styleMask:backing:defer:screen:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentRect_styleMask_backing_defer_screen(
            this: Allocated<Self>,
            content_rect: NSRect,
            style: NSWindowStyleMask,
            backing_store_type: NSBackingStoreType,
            flag: bool,
            screen: Option<&NSScreen>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        #[cfg(feature = "NSViewController")]
        /// Convenience method for creating an autoreleased titled window with the given contentViewController. A basic NSWindow with the following attributes is made: titled, closable, resizable, miniaturizable. The window's title is automatically bound to the contentViewController's title. The size of the window can easily be controlled by utilizing autolayout and applying size constraints to the view (or its subviews). The window has isReleasedWhenClosed set to NO, and it must be explicitly retained to keep the window instance alive. To have it automatically be freed when it is closed, do the following: [window retain] and [window setReleasedWhenClosed:YES].
        #[unsafe(method(windowWithContentViewController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn windowWithContentViewController(
            content_view_controller: &NSViewController,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSPanel", feature = "NSResponder", feature = "NSWindow"))]
impl NSSavePanel {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSPanel", feature = "NSResponder", feature = "NSWindow"))]
impl NSSavePanel {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsopensavepaneldelegate?language=objc)
    pub unsafe trait NSOpenSavePanelDelegate: NSObjectProtocol + MainThreadOnly {
        /// Optional — Enabling URLs.
        /// `NSSavePanel`: This method is not sent. All urls are always disabled.
        /// `NSOpenPanel`: Return `YES` to allow the `url` to be enabled in the panel. Delegate implementations should be fast to avoid stalling the UI. Applications linked on Mac OS 10.7 and later should be prepared to handle non-file URL schemes.
        #[optional]
        #[unsafe(method(panel:shouldEnableURL:))]
        #[unsafe(method_family = none)]
        unsafe fn panel_shouldEnableURL(&self, sender: &AnyObject, url: &NSURL) -> bool;

        /// Optional — URL validation for saving and opening files.
        /// `NSSavePanel`: Sent once by the save panel when the user clicks the Save button. The user is intending to save a file at `url`. Return `YES` if the `url` is a valid location to save to. Return `NO` and return by reference `outError` with a user displayable error message for why the `url` is not valid. If a recovery option is provided by the error, and recovery succeeded, the panel will attempt to close again.
        /// - Note: An item at `url` may not physically exist yet, unless the user decided to overwrite an existing item.
        /// `NSOpenPanel`: Sent once for each selected filename (or directory) when the user chooses the Open button. Return `YES` if the `url` is acceptable to open. Return `NO` and return by reference `outError` with a user displayable message for why the `url` is not valid for opening. If a recovery option is provided by the error, and recovery succeeded, the panel will attempt to close again.
        /// - Note: Implement this delegate method instead of  `panel:shouldEnableURL:` if the processing of the selected item takes a long time.
        #[optional]
        #[unsafe(method(panel:validateURL:error:_))]
        #[unsafe(method_family = none)]
        unsafe fn panel_validateURL_error(
            &self,
            sender: &AnyObject,
            url: &NSURL,
        ) -> Result<(), Retained<NSError>>;

        /// Optional — Sent when the user selected the directory located at `url`. `url` may be `nil`. if the current directory can't be represented by an NSURL object (ie: the media sidebar directory, or the "Computer").
        #[optional]
        #[unsafe(method(panel:didChangeToDirectoryURL:))]
        #[unsafe(method_family = none)]
        unsafe fn panel_didChangeToDirectoryURL(&self, sender: &AnyObject, url: Option<&NSURL>);

        /// Optional — Filename customization for the NSSavePanel. Allows the delegate to customize the filename entered by the user, before the extension is appended, and before the user is potentially asked to replace a file.
        #[optional]
        #[unsafe(method(panel:userEnteredFilename:confirmed:))]
        #[unsafe(method_family = none)]
        unsafe fn panel_userEnteredFilename_confirmed(
            &self,
            sender: &AnyObject,
            filename: &NSString,
            ok_flag: bool,
        ) -> Option<Retained<NSString>>;

        /// Optional — Sent when the user clicks the disclosure triangle to expand or collapse the file browser while in NSOpenPanel.
        #[optional]
        #[unsafe(method(panel:willExpand:))]
        #[unsafe(method_family = none)]
        unsafe fn panel_willExpand(&self, sender: &AnyObject, expanding: bool);

        /// Optional — Sent when the user has changed the selection.
        #[optional]
        #[unsafe(method(panelSelectionDidChange:))]
        #[unsafe(method_family = none)]
        unsafe fn panelSelectionDidChange(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "objc2-uniform-type-identifiers")]
        #[cfg(target_vendor = "apple")]
        /// `NSSavePanel`: Optional — Sent when the content type popup is displayed and the save panel needs the display name for a type. If `nil` is returned, the save panel will display type's `localizedDescription`.
        /// `NSOpenPanel`: Not sent.
        #[optional]
        #[unsafe(method(panel:displayNameForType:))]
        #[unsafe(method_family = none)]
        unsafe fn panel_displayNameForType(
            &self,
            sender: &AnyObject,
            r#type: &UTType,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "objc2-uniform-type-identifiers")]
        #[cfg(target_vendor = "apple")]
        /// `NSSavePanel`: Optional — Sent when the user changes the current type.
        /// `NSOpenPanel`: Not sent.
        #[optional]
        #[unsafe(method(panel:didSelectType:))]
        #[unsafe(method_family = none)]
        unsafe fn panel_didSelectType(&self, sender: &AnyObject, r#type: Option<&UTType>);
    }
);

/// NSDeprecated.
#[cfg(all(feature = "NSPanel", feature = "NSResponder", feature = "NSWindow"))]
impl NSSavePanel {
    extern_methods!(
        #[deprecated = "Use -URL instead"]
        #[unsafe(method(filename))]
        #[unsafe(method_family = none)]
        pub unsafe fn filename(&self) -> Retained<NSString>;

        #[deprecated = "Use -directoryURL instead"]
        #[unsafe(method(directory))]
        #[unsafe(method_family = none)]
        pub unsafe fn directory(&self) -> Retained<NSString>;

        #[deprecated = "Use -setDirectoryURL: instead"]
        #[unsafe(method(setDirectory:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDirectory(&self, path: Option<&NSString>);

        #[deprecated = "Use -allowedContentTypes instead"]
        #[unsafe(method(requiredFileType))]
        #[unsafe(method_family = none)]
        pub unsafe fn requiredFileType(&self) -> Option<Retained<NSString>>;

        #[deprecated = "Use -allowedContentTypes: instead"]
        #[unsafe(method(setRequiredFileType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRequiredFileType(&self, r#type: Option<&NSString>);

        #[deprecated = "Use beginSheetModalForWindow:completionHandler: instead. The following parameters are replaced by properties: 'path' is replaced by 'directoryURL' and 'name' by 'nameFieldStringValue'."]
        #[unsafe(method(beginSheetForDirectory:file:modalForWindow:modalDelegate:didEndSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn beginSheetForDirectory_file_modalForWindow_modalDelegate_didEndSelector_contextInfo(
            &self,
            path: Option<&NSString>,
            name: Option<&NSString>,
            doc_window: Option<&NSWindow>,
            delegate: Option<&AnyObject>,
            did_end_selector: Option<Sel>,
            context_info: *mut c_void,
        );

        #[deprecated = "Use -runModal instead. The following parameters are replaced by properties: 'path' is replaced by 'directoryURL' and 'name' by 'nameFieldStringValue'."]
        #[unsafe(method(runModalForDirectory:file:))]
        #[unsafe(method_family = none)]
        pub unsafe fn runModalForDirectory_file(
            &self,
            path: Option<&NSString>,
            name: Option<&NSString>,
        ) -> NSInteger;

        #[deprecated = "Default implementation does nothing."]
        #[unsafe(method(selectText:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectText(&self, sender: Option<&AnyObject>);

        /// `NSSavePanel`: An array of NSStrings specifying the file types the user can save the file as. The file type can be a common file extension, or a UTI. A nil value indicates that any file type can be used. If the array is not nil and the array contains no items, an exception will be raised. If no extension is given by the user, the first item in the allowedFileTypes will be used as the extension for the save panel. If the user specifies a type not in the array, and 'allowsOtherFileTypes' is YES, they will be presented with another dialog when prompted to save. The default value is 'nil'.
        /// `NSOpenPanel`: On versions less than 10.6, this property is ignored. For applications that link against 10.6 and higher, this property will determine which files should be enabled in the open panel. Using the deprecated methods to show the open panel (the ones that take a "types:" parameter) will overwrite this value, and should not be used. The allowedFileTypes can be changed while the panel is running (ie: from an accessory view). The file type can be a common file extension, or a UTI. This is also known as the "enabled file types". A nil value indicates that all files should be enabled.
        #[deprecated = "Use -allowedContentTypes instead"]
        #[unsafe(method(allowedFileTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowedFileTypes(&self) -> Option<Retained<NSArray<NSString>>>;

        /// Setter for [`allowedFileTypes`][Self::allowedFileTypes].
        #[deprecated = "Use -allowedContentTypes instead"]
        #[unsafe(method(setAllowedFileTypes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowedFileTypes(&self, allowed_file_types: Option<&NSArray<NSString>>);
    );
}
