# Fluentd Governance

## Principles

The Fluentd community adheres to the following principles:

- Open: Fluentd is open source. See repository guidelines and CLA, below.
- Welcoming and respectful: See Code of Conduct, below.
- Transparent and accessible: Work and collaboration are done in public.
- Merit: Ideas and contributions are accepted according to their technical merit and alignment with project objectives, scope, and design principles.

## Voting

The Fluentd project employs "organization voting" to ensure no single organization can dominate the project.

Individuals not associated with or employed by a company or organization are allowed one organization vote. Each company or organization (regardless of the number of maintainers associated with or employed by that company/organization) receives one organization vote.

In other words, if two maintainers are employed by Company X, two by Company Y, two by Company Z, and one maintainer is an un-affiliated individual, a total of four "organization votes" are possible; one for X, one for Y, one for Z, and one for the un-affiliated individual.

Any maintainer from an organization may cast the vote for that organization.

For formal votes, a specific statement of what is being voted on should be added to the relevant github issue or PR, and a link to that issue or PR added to the maintainers meeting agenda document. Maintainers should indicate their yes/no vote on that issue or PR, and after a suitable period of time, the votes will be tallied and the outcome noted.

## Changes in Maintainership

New maintainers are proposed by an existing maintainer and are elected by a 2/3 majority organization vote.

Maintainers can be removed by a 2/3 majority organization vote.

## Github Project Administration

Maintainers will be added to the __fluent__ GitHub organization and added to the GitHub cni-maintainers team, and made a GitHub maintainer of that team.

After 6 months a maintainer will be made an "owner" of the GitHub organization.

## Projects

The fluent organization is open to receive new sub-projects under it umbrella. To apply a project as part of the __fluent__ organization, it has to met the following criteria:

- Licensed under the terms of the Apache License v2.0
- Project has been active for at least one year since it inception
- More than 2 contributors
- Related to one or more scopes of Fluentd ecosystem:
  - Data collection
  - Log management
  - Metering
- Be supported by 2/3 majority of organization

The submission process starts as a Pull Request on Fluentd repository with the required information mentioned above. Once a project is accepted, it's considered a __CNCF sub-project under the umbrella of Fluentd__

## Code of Conduct

Fluentd follows the CNCF Code of Conduct:

https://github.com/cncf/foundation/blob/master/code-of-conduct.md
