/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;

public class SubkeyBindingSignatureBuilder
extends AbstractSignatureBuilder<SubkeyBindingSignatureBuilder> {
    public SubkeyBindingSignatureBuilder(PGPSecretKey signingKey, SecretKeyRingProtector protector) throws PGPException {
        super(SignatureType.SUBKEY_BINDING, signingKey, protector);
    }

    public SubkeyBindingSignatureBuilder(PGPSecretKey signingKey, SecretKeyRingProtector protector, HashAlgorithm hashAlgorithm) throws PGPException {
        super(SignatureType.SUBKEY_BINDING, signingKey, protector, hashAlgorithm, SignatureSubpackets.createHashedSubpackets(signingKey.getPublicKey()), SignatureSubpackets.createEmptySubpackets());
    }

    public SubkeyBindingSignatureBuilder(PGPSecretKey signingKey, SecretKeyRingProtector protector, PGPSignature oldSubkeyBinding) throws PGPException {
        super(signingKey, protector, SubkeyBindingSignatureBuilder.requireValidSignatureType(oldSubkeyBinding));
    }

    private static PGPSignature requireValidSignatureType(PGPSignature signature) {
        if (signature.getSignatureType() == SignatureType.SUBKEY_BINDING.getCode()) {
            return signature;
        }
        throw new IllegalArgumentException("Invalid signature type.");
    }

    @Override
    protected boolean isValidSignatureType(SignatureType type) {
        return type == SignatureType.SUBKEY_BINDING;
    }

    public SelfSignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    public SelfSignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    public void applyCallback(@Nullable SelfSignatureSubpackets.Callback callback) {
        if (callback != null) {
            callback.modifyHashedSubpackets(this.getHashedSubpackets());
            callback.modifyUnhashedSubpackets(this.getUnhashedSubpackets());
        }
    }

    public PGPSignature build(PGPPublicKey subkey) throws PGPException {
        return this.buildAndInitSignatureGenerator().generateCertification(this.publicSigningKey, subkey);
    }
}

