/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.reference.provider;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.reference.element.ReferenceElement;
import org.jxmpp.JxmppContext;

public class ReferenceProvider
extends ExtensionElementProvider<ReferenceElement> {
    public static final ReferenceProvider TEST_PROVIDER = new ReferenceProvider();

    @Override
    public ReferenceElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException {
        URI uri;
        Integer begin = ParserUtils.getIntegerAttribute(parser, "begin");
        Integer end = ParserUtils.getIntegerAttribute(parser, "end");
        String typeString = parser.getAttributeValue(null, "type");
        ReferenceElement.Type type = ReferenceElement.Type.valueOf(typeString);
        String anchor = parser.getAttributeValue(null, "anchor");
        String uriString = parser.getAttributeValue(null, "uri");
        try {
            uri = uriString != null ? new URI(uriString) : null;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        XmlElement child = null;
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                String namespace;
                String elementName = parser.getName();
                ExtensionElementProvider<ExtensionElement> provider = ProviderManager.getExtensionProvider(elementName, namespace = parser.getNamespace());
                if (provider == null) continue;
                child = (XmlElement)provider.parse(parser);
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT) break;
        }
        return new ReferenceElement(begin, end, type, anchor, uri, child);
    }
}

