/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.util.Strings;

public class NotationData
extends SignatureSubpacket {
    public static final int HEADER_FLAG_LENGTH = 4;
    public static final int HEADER_NAME_LENGTH = 2;
    public static final int HEADER_VALUE_LENGTH = 2;

    public NotationData(boolean bl, boolean bl2, byte[] byArray) {
        super(20, bl, bl2, byArray);
    }

    public NotationData(boolean bl, boolean bl2, String string2, String string3) {
        super(20, bl, false, NotationData.createData(bl2, string2, string3));
    }

    private static byte[] createData(boolean bl, String string2, String string3) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(bl ? 128 : 0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byte[] byArray = null;
        byte[] byArray2 = Strings.toUTF8ByteArray(string2);
        int n = Math.min(byArray2.length, 65535);
        if (n != byArray2.length) {
            throw new IllegalArgumentException("notationName exceeds maximum length.");
        }
        byArray = Strings.toUTF8ByteArray(string3);
        int n2 = Math.min(byArray.length, 65535);
        if (n2 != byArray.length) {
            throw new IllegalArgumentException("notationValue exceeds maximum length.");
        }
        byteArrayOutputStream.write(n >>> 8 & 0xFF);
        byteArrayOutputStream.write(n >>> 0 & 0xFF);
        byteArrayOutputStream.write(n2 >>> 8 & 0xFF);
        byteArrayOutputStream.write(n2 >>> 0 & 0xFF);
        byteArrayOutputStream.write(byArray2, 0, n);
        byteArrayOutputStream.write(byArray, 0, n2);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isHumanReadable() {
        return this.data[0] == -128;
    }

    public String getNotationName() {
        int n = ((this.data[4] & 0xFF) << 8) + (this.data[5] & 0xFF);
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, 8, byArray, 0, n);
        return Strings.fromUTF8ByteArray(byArray);
    }

    public String getNotationValue() {
        return Strings.fromUTF8ByteArray(this.getNotationValueBytes());
    }

    public byte[] getNotationValueBytes() {
        int n = ((this.data[4] & 0xFF) << 8) + (this.data[5] & 0xFF);
        int n2 = ((this.data[6] & 0xFF) << 8) + (this.data[7] & 0xFF);
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, 8 + n, byArray, 0, n2);
        return byArray;
    }
}

