/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef EncoderTraits_h_
#define EncoderTraits_h_

#include "PEMFactory.h"
#include "mozilla/dom/EncoderTypes.h"

namespace mozilla::EncoderSupport {

template <typename T>
bool Supports(const RefPtr<T>& aEncoderConfigInternal) {
  RefPtr<PEMFactory> factory = new PEMFactory();
  EncoderConfig config = aEncoderConfigInternal->ToEncoderConfig();
  return !factory->Supports(config).isEmpty();
}

}  // namespace mozilla::EncoderSupport

#endif
