//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// Describes how a resource will be used by a shader through an argument buffer
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlresourceusage?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLResourceUsage(pub NSUInteger);
bitflags::bitflags! {
    impl MTLResourceUsage: NSUInteger {
        #[doc(alias = "MTLResourceUsageRead")]
        const Read = 1<<0;
        #[doc(alias = "MTLResourceUsageWrite")]
        const Write = 1<<1;
        #[doc(alias = "MTLResourceUsageSample")]
#[deprecated]
        const Sample = 1<<2;
    }
}

unsafe impl Encode for MTLResourceUsage {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLResourceUsage {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Describes the types of resources that the a barrier operates on
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlbarrierscope?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLBarrierScope(pub NSUInteger);
bitflags::bitflags! {
    impl MTLBarrierScope: NSUInteger {
        #[doc(alias = "MTLBarrierScopeBuffers")]
        const Buffers = 1<<0;
        #[doc(alias = "MTLBarrierScopeTextures")]
        const Textures = 1<<1;
        #[doc(alias = "MTLBarrierScopeRenderTargets")]
        const RenderTargets = 1<<2;
    }
}

unsafe impl Encode for MTLBarrierScope {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLBarrierScope {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// MTLCommandEncoder is the common interface for objects that write commands into MTLCommandBuffers.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandencoder?language=objc)
    pub unsafe trait MTLCommandEncoder: NSObjectProtocol {
        #[cfg(feature = "MTLDevice")]
        /// The device this resource was created against.
        #[unsafe(method(device))]
        #[unsafe(method_family = none)]
        unsafe fn device(&self) -> Retained<ProtocolObject<dyn MTLDevice>>;

        /// A string to help identify this object.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        fn label(&self) -> Option<Retained<NSString>>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        fn setLabel(&self, label: Option<&NSString>);

        /// Declare that all command generation from this encoder is complete, and detach from the MTLCommandBuffer.
        #[unsafe(method(endEncoding))]
        #[unsafe(method_family = none)]
        fn endEncoding(&self);

        /// Inserts a debug string into the command buffer.  This does not change any API behavior, but can be useful when debugging.
        #[unsafe(method(insertDebugSignpost:))]
        #[unsafe(method_family = none)]
        fn insertDebugSignpost(&self, string: &NSString);

        /// Push a new named string onto a stack of string labels.
        #[unsafe(method(pushDebugGroup:))]
        #[unsafe(method_family = none)]
        fn pushDebugGroup(&self, string: &NSString);

        /// Pop the latest named string off of the stack.
        #[unsafe(method(popDebugGroup))]
        #[unsafe(method_family = none)]
        fn popDebugGroup(&self);
    }
);
