// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Determines which tools the model should request in a call to <code>Converse</code> or <code>ConverseStream</code>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html">Call a tool with the Converse API</a> in the Amazon Bedrock User Guide.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum ToolChoice {
    /// <p>The model must request at least one tool (no text is generated).</p>
    Any(crate::types::AnyToolChoice),
    /// <p>(Default). The Model automatically decides if a tool should be called or whether to generate text instead.</p>
    Auto(crate::types::AutoToolChoice),
    /// <p>The Model must request the specified tool. Only supported by Anthropic Claude 3 and Amazon Nova models.</p>
    Tool(crate::types::SpecificToolChoice),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ToolChoice {
    /// Tries to convert the enum instance into [`Any`](crate::types::ToolChoice::Any), extracting the inner [`AnyToolChoice`](crate::types::AnyToolChoice).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_any(&self) -> ::std::result::Result<&crate::types::AnyToolChoice, &Self> {
        if let ToolChoice::Any(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Any`](crate::types::ToolChoice::Any).
    pub fn is_any(&self) -> bool {
        self.as_any().is_ok()
    }
    /// Tries to convert the enum instance into [`Auto`](crate::types::ToolChoice::Auto), extracting the inner [`AutoToolChoice`](crate::types::AutoToolChoice).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_auto(&self) -> ::std::result::Result<&crate::types::AutoToolChoice, &Self> {
        if let ToolChoice::Auto(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Auto`](crate::types::ToolChoice::Auto).
    pub fn is_auto(&self) -> bool {
        self.as_auto().is_ok()
    }
    /// Tries to convert the enum instance into [`Tool`](crate::types::ToolChoice::Tool), extracting the inner [`SpecificToolChoice`](crate::types::SpecificToolChoice).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_tool(&self) -> ::std::result::Result<&crate::types::SpecificToolChoice, &Self> {
        if let ToolChoice::Tool(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Tool`](crate::types::ToolChoice::Tool).
    pub fn is_tool(&self) -> bool {
        self.as_tool().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
