// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains the logical translation of natural language input into formal logical statements, including premises, claims, and confidence scores.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailAutomatedReasoningTranslation {
    /// <p>The logical statements that serve as the foundation or assumptions for the claims.</p>
    pub premises: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>,
    /// <p>The logical statements that are being validated against the premises and policy rules.</p>
    pub claims: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>,
    /// <p>References to portions of the original input text that correspond to the premises but could not be fully translated.</p>
    pub untranslated_premises: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningInputTextReference>>,
    /// <p>References to portions of the original input text that correspond to the claims but could not be fully translated.</p>
    pub untranslated_claims: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningInputTextReference>>,
    /// <p>A confidence score between 0 and 1 indicating how certain the system is about the logical translation.</p>
    pub confidence: ::std::option::Option<f64>,
}
impl GuardrailAutomatedReasoningTranslation {
    /// <p>The logical statements that serve as the foundation or assumptions for the claims.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.premises.is_none()`.
    pub fn premises(&self) -> &[crate::types::GuardrailAutomatedReasoningStatement] {
        self.premises.as_deref().unwrap_or_default()
    }
    /// <p>The logical statements that are being validated against the premises and policy rules.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.claims.is_none()`.
    pub fn claims(&self) -> &[crate::types::GuardrailAutomatedReasoningStatement] {
        self.claims.as_deref().unwrap_or_default()
    }
    /// <p>References to portions of the original input text that correspond to the premises but could not be fully translated.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.untranslated_premises.is_none()`.
    pub fn untranslated_premises(&self) -> &[crate::types::GuardrailAutomatedReasoningInputTextReference] {
        self.untranslated_premises.as_deref().unwrap_or_default()
    }
    /// <p>References to portions of the original input text that correspond to the claims but could not be fully translated.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.untranslated_claims.is_none()`.
    pub fn untranslated_claims(&self) -> &[crate::types::GuardrailAutomatedReasoningInputTextReference] {
        self.untranslated_claims.as_deref().unwrap_or_default()
    }
    /// <p>A confidence score between 0 and 1 indicating how certain the system is about the logical translation.</p>
    pub fn confidence(&self) -> ::std::option::Option<f64> {
        self.confidence
    }
}
impl GuardrailAutomatedReasoningTranslation {
    /// Creates a new builder-style object to manufacture [`GuardrailAutomatedReasoningTranslation`](crate::types::GuardrailAutomatedReasoningTranslation).
    pub fn builder() -> crate::types::builders::GuardrailAutomatedReasoningTranslationBuilder {
        crate::types::builders::GuardrailAutomatedReasoningTranslationBuilder::default()
    }
}

/// A builder for [`GuardrailAutomatedReasoningTranslation`](crate::types::GuardrailAutomatedReasoningTranslation).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailAutomatedReasoningTranslationBuilder {
    pub(crate) premises: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>,
    pub(crate) claims: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>,
    pub(crate) untranslated_premises: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningInputTextReference>>,
    pub(crate) untranslated_claims: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningInputTextReference>>,
    pub(crate) confidence: ::std::option::Option<f64>,
}
impl GuardrailAutomatedReasoningTranslationBuilder {
    /// Appends an item to `premises`.
    ///
    /// To override the contents of this collection use [`set_premises`](Self::set_premises).
    ///
    /// <p>The logical statements that serve as the foundation or assumptions for the claims.</p>
    pub fn premises(mut self, input: crate::types::GuardrailAutomatedReasoningStatement) -> Self {
        let mut v = self.premises.unwrap_or_default();
        v.push(input);
        self.premises = ::std::option::Option::Some(v);
        self
    }
    /// <p>The logical statements that serve as the foundation or assumptions for the claims.</p>
    pub fn set_premises(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>) -> Self {
        self.premises = input;
        self
    }
    /// <p>The logical statements that serve as the foundation or assumptions for the claims.</p>
    pub fn get_premises(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>> {
        &self.premises
    }
    /// Appends an item to `claims`.
    ///
    /// To override the contents of this collection use [`set_claims`](Self::set_claims).
    ///
    /// <p>The logical statements that are being validated against the premises and policy rules.</p>
    pub fn claims(mut self, input: crate::types::GuardrailAutomatedReasoningStatement) -> Self {
        let mut v = self.claims.unwrap_or_default();
        v.push(input);
        self.claims = ::std::option::Option::Some(v);
        self
    }
    /// <p>The logical statements that are being validated against the premises and policy rules.</p>
    pub fn set_claims(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>>) -> Self {
        self.claims = input;
        self
    }
    /// <p>The logical statements that are being validated against the premises and policy rules.</p>
    pub fn get_claims(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningStatement>> {
        &self.claims
    }
    /// Appends an item to `untranslated_premises`.
    ///
    /// To override the contents of this collection use [`set_untranslated_premises`](Self::set_untranslated_premises).
    ///
    /// <p>References to portions of the original input text that correspond to the premises but could not be fully translated.</p>
    pub fn untranslated_premises(mut self, input: crate::types::GuardrailAutomatedReasoningInputTextReference) -> Self {
        let mut v = self.untranslated_premises.unwrap_or_default();
        v.push(input);
        self.untranslated_premises = ::std::option::Option::Some(v);
        self
    }
    /// <p>References to portions of the original input text that correspond to the premises but could not be fully translated.</p>
    pub fn set_untranslated_premises(
        mut self,
        input: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningInputTextReference>>,
    ) -> Self {
        self.untranslated_premises = input;
        self
    }
    /// <p>References to portions of the original input text that correspond to the premises but could not be fully translated.</p>
    pub fn get_untranslated_premises(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningInputTextReference>> {
        &self.untranslated_premises
    }
    /// Appends an item to `untranslated_claims`.
    ///
    /// To override the contents of this collection use [`set_untranslated_claims`](Self::set_untranslated_claims).
    ///
    /// <p>References to portions of the original input text that correspond to the claims but could not be fully translated.</p>
    pub fn untranslated_claims(mut self, input: crate::types::GuardrailAutomatedReasoningInputTextReference) -> Self {
        let mut v = self.untranslated_claims.unwrap_or_default();
        v.push(input);
        self.untranslated_claims = ::std::option::Option::Some(v);
        self
    }
    /// <p>References to portions of the original input text that correspond to the claims but could not be fully translated.</p>
    pub fn set_untranslated_claims(
        mut self,
        input: ::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningInputTextReference>>,
    ) -> Self {
        self.untranslated_claims = input;
        self
    }
    /// <p>References to portions of the original input text that correspond to the claims but could not be fully translated.</p>
    pub fn get_untranslated_claims(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::GuardrailAutomatedReasoningInputTextReference>> {
        &self.untranslated_claims
    }
    /// <p>A confidence score between 0 and 1 indicating how certain the system is about the logical translation.</p>
    pub fn confidence(mut self, input: f64) -> Self {
        self.confidence = ::std::option::Option::Some(input);
        self
    }
    /// <p>A confidence score between 0 and 1 indicating how certain the system is about the logical translation.</p>
    pub fn set_confidence(mut self, input: ::std::option::Option<f64>) -> Self {
        self.confidence = input;
        self
    }
    /// <p>A confidence score between 0 and 1 indicating how certain the system is about the logical translation.</p>
    pub fn get_confidence(&self) -> &::std::option::Option<f64> {
        &self.confidence
    }
    /// Consumes the builder and constructs a [`GuardrailAutomatedReasoningTranslation`](crate::types::GuardrailAutomatedReasoningTranslation).
    pub fn build(self) -> crate::types::GuardrailAutomatedReasoningTranslation {
        crate::types::GuardrailAutomatedReasoningTranslation {
            premises: self.premises,
            claims: self.claims,
            untranslated_premises: self.untranslated_premises,
            untranslated_claims: self.untranslated_claims,
            confidence: self.confidence,
        }
    }
}
