// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_PLATFORM_LOADER_CORS_CORS_ERROR_STRING_H_
#define THIRD_PARTY_BLINK_RENDERER_PLATFORM_LOADER_CORS_CORS_ERROR_STRING_H_

#include "services/network/public/cpp/cors/cors_error_status.h"
#include "third_party/blink/public/platform/web_url_request.h"
#include "third_party/blink/renderer/platform/platform_export.h"

namespace WTF {
class AtomicString;
class String;
}  // namespace WTF

namespace blink {

class KURL;
class SecurityOrigin;
enum class ResourceType : uint8_t;

// CORS error strings related utility functions.
namespace cors {

// Stringify CorsError mainly for inspector messages. Generated string should
// not be exposed to JavaScript for security reasons.
PLATFORM_EXPORT WTF::String GetErrorString(
    const network::CorsErrorStatus& status,
    const KURL& initial_request_url,
    const KURL& last_request_url,
    const SecurityOrigin& origin,
    ResourceType resource_type,
    const WTF::AtomicString& initiator_name);

}  // namespace cors

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_PLATFORM_LOADER_CORS_CORS_ERROR_STRING_H_
