/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.ModuleDeliveryType;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.SubValidator;

final class StandaloneFeatureModulesValidator
extends SubValidator {
    StandaloneFeatureModulesValidator() {
    }

    @Override
    public void validateBundle(AppBundle bundle) {
        if (!bundle.hasBaseModule() || !bundle.getBundleConfig().getOptimizations().getStandaloneConfig().getFeatureModulesMode().equals(Config.StandaloneConfig.FeatureModulesMode.SEPARATE_FEATURE_MODULES)) {
            return;
        }
        if (bundle.getBaseModule().getAndroidManifest().getEffectiveMinSdkVersion() >= 21) {
            throw InvalidBundleException.createWithUserMessage("STANDALONE_FEATURE_MODULES can only be used for Android App Bundles with minSdk < 21.");
        }
        boolean onlyOnDemandFeatures = bundle.getFeatureModules().values().stream().filter(module -> !module.isBaseModule()).allMatch(module -> module.getDeliveryType() == ModuleDeliveryType.NO_INITIAL_INSTALL);
        if (!onlyOnDemandFeatures) {
            throw InvalidBundleException.createWithUserMessage("Only on-demand feature modules are supported for Android App Bundles with STANDALONE_FEATURE_MODULES enabled.");
        }
        if (!bundle.getAssetModules().isEmpty()) {
            throw InvalidBundleException.createWithUserMessage("Asset modules are not supported for Android App Bundles with STANDALONE_FEATURE_MODULES enabled.");
        }
    }
}

