package memory

import (
	"fmt"
	"strings"
)

// Code generated by cdproto-gen. DO NOT EDIT.

// PressureLevel memory pressure level.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Memory#type-PressureLevel
type PressureLevel string

// String returns the PressureLevel as string value.
func (t PressureLevel) String() string {
	return string(t)
}

// PressureLevel values.
const (
	PressureLevelModerate PressureLevel = "moderate"
	PressureLevelCritical PressureLevel = "critical"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *PressureLevel) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch PressureLevel(s) {
	case PressureLevelModerate:
		*t = PressureLevelModerate
	case PressureLevelCritical:
		*t = PressureLevelCritical
	default:
		return fmt.Errorf("unknown PressureLevel value: %v", s)
	}
	return nil
}

// SamplingProfileNode heap profile sample.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Memory#type-SamplingProfileNode
type SamplingProfileNode struct {
	Size  float64  `json:"size"`  // Size of the sampled allocation.
	Total float64  `json:"total"` // Total bytes attributed to this sample.
	Stack []string `json:"stack"` // Execution stack at the point of allocation.
}

// SamplingProfile array of heap profile samples.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Memory#type-SamplingProfile
type SamplingProfile struct {
	Samples []*SamplingProfileNode `json:"samples"`
	Modules []*Module              `json:"modules"`
}

// Module executable module information.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Memory#type-Module
type Module struct {
	Name        string  `json:"name"`        // Name of the module.
	UUID        string  `json:"uuid"`        // UUID of the module.
	BaseAddress string  `json:"baseAddress"` // Base address where the module is loaded into memory. Encoded as a decimal or hexadecimal (0x prefixed) string.
	Size        float64 `json:"size"`        // Size of the module in bytes.
}

// DOMCounter DOM object counter data.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Memory#type-DOMCounter
type DOMCounter struct {
	Name  string `json:"name"`  // Object name. Note: object names should be presumed volatile and clients should not expect the returned names to be consistent across runs.
	Count int64  `json:"count"` // Object count.
}
