/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct RentalVehicle {
    /// Unique identifier of the rental vehicle
    #[serde(rename = "id")]
    pub id: String,
    /// Unique identifier of the rental provider
    #[serde(rename = "providerId")]
    pub provider_id: String,
    /// Unique identifier of the rental provider group
    #[serde(rename = "providerGroupId")]
    pub provider_group_id: String,
    /// Vehicle type ID (unique within the provider)
    #[serde(rename = "typeId")]
    pub type_id: String,
    /// latitude
    #[serde(rename = "lat")]
    pub lat: f64,
    /// longitude
    #[serde(rename = "lon")]
    pub lon: f64,
    #[serde(rename = "formFactor")]
    pub form_factor: models::RentalFormFactor,
    #[serde(rename = "propulsionType")]
    pub propulsion_type: models::RentalPropulsionType,
    #[serde(rename = "returnConstraint")]
    pub return_constraint: models::RentalReturnConstraint,
    /// Station ID if the vehicle is currently at a station
    #[serde(rename = "stationId", skip_serializing_if = "Option::is_none")]
    pub station_id: Option<String>,
    /// Station ID where the vehicle must be returned, if applicable
    #[serde(rename = "homeStationId", skip_serializing_if = "Option::is_none")]
    pub home_station_id: Option<String>,
    /// true if the vehicle is currently reserved by a customer, false otherwise
    #[serde(rename = "isReserved")]
    pub is_reserved: bool,
    /// true if the vehicle is out of service, false otherwise
    #[serde(rename = "isDisabled")]
    pub is_disabled: bool,
    /// Rental URI for Android (deep link to the specific vehicle)
    #[serde(rename = "rentalUriAndroid", skip_serializing_if = "Option::is_none")]
    pub rental_uri_android: Option<String>,
    /// Rental URI for iOS (deep link to the specific vehicle)
    #[serde(rename = "rentalUriIOS", skip_serializing_if = "Option::is_none")]
    pub rental_uri_ios: Option<String>,
    /// Rental URI for web (deep link to the specific vehicle)
    #[serde(rename = "rentalUriWeb", skip_serializing_if = "Option::is_none")]
    pub rental_uri_web: Option<String>,
}

impl RentalVehicle {
    pub fn new(id: String, provider_id: String, provider_group_id: String, type_id: String, lat: f64, lon: f64, form_factor: models::RentalFormFactor, propulsion_type: models::RentalPropulsionType, return_constraint: models::RentalReturnConstraint, is_reserved: bool, is_disabled: bool) -> RentalVehicle {
        RentalVehicle {
            id,
            provider_id,
            provider_group_id,
            type_id,
            lat,
            lon,
            form_factor,
            propulsion_type,
            return_constraint,
            station_id: None,
            home_station_id: None,
            is_reserved,
            is_disabled,
            rental_uri_android: None,
            rental_uri_ios: None,
            rental_uri_web: None,
        }
    }
}

