use core::cmp::Ordering;

use crate::soft_f64::F64;

pub(crate) const fn eq(l: F64, r: F64) -> bool {
    if let Some(ord) = l.cmp(r) {
        match ord {
            Ordering::Equal => true,
            _ => false,
        }
    } else {
        panic!("Failed to compare values");
    }
}

pub(crate) const fn gt(l: F64, r: F64) -> bool {
    if let Some(ord) = l.cmp(r) {
        match ord {
            Ordering::Greater => true,
            _ => false,
        }
    } else {
        panic!("Failed to compare values");
    }
}

pub(crate) const fn ge(l: F64, r: F64) -> bool {
    if let Some(ord) = l.cmp(r) {
        match ord {
            Ordering::Less => false,
            _ => true,
        }
    } else {
        panic!("Failed to compare values");
    }
}

pub(crate) const fn lt(l: F64, r: F64) -> bool {
    if let Some(ord) = l.cmp(r) {
        match ord {
            Ordering::Less => true,
            _ => false,
        }
    } else {
        panic!("Failed to compare values");
    }
}
