/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.scala.jnr;

import eu.geekplace.scala.jnr.Linux;
import java.io.Serializable;
import jnr.ffi.LastError;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Runtime;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import scala.MatchError;
import scala.Tuple3;
import scala.Tuple3$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Linux$
implements Serializable {
    private static final int CLOCK_REALTIME;
    private static final int CLOCK_MONOTONIC;
    private static final int CLOCK_REALTIME_ALARM;
    private static final int CLOCK_BOOTTIME_ALARM;
    private static final int TFD_CLOEXEC;
    private static final int TFD_NONBLOCK;
    private static final int TFD_TIMER_ABSTIME;
    private static final int TFD_TIMER_CANCEL_ON_SET;
    private static final Linux.Interface libc;
    private static final Runtime jnrRuntime;
    private static final POSIX posix;
    public static final Linux$ MODULE$;

    private Linux$() {
    }

    static {
        MODULE$ = new Linux$();
        CLOCK_REALTIME = 0;
        CLOCK_MONOTONIC = 1;
        CLOCK_REALTIME_ALARM = 8;
        CLOCK_BOOTTIME_ALARM = 9;
        TFD_CLOEXEC = 524288;
        TFD_NONBLOCK = 2048;
        TFD_TIMER_ABSTIME = 1;
        TFD_TIMER_CANCEL_ON_SET = 2;
        libc = LibraryLoader.create(Linux.Interface.class).load("c");
        jnrRuntime = Runtime.getRuntime(MODULE$.libc());
        posix = POSIXFactory.getPOSIX();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Linux$.class);
    }

    public int CLOCK_REALTIME() {
        return CLOCK_REALTIME;
    }

    public int CLOCK_MONOTONIC() {
        return CLOCK_MONOTONIC;
    }

    public int CLOCK_REALTIME_ALARM() {
        return CLOCK_REALTIME_ALARM;
    }

    public int CLOCK_BOOTTIME_ALARM() {
        return CLOCK_BOOTTIME_ALARM;
    }

    public int TFD_CLOEXEC() {
        return TFD_CLOEXEC;
    }

    public int TFD_NONBLOCK() {
        return TFD_NONBLOCK;
    }

    public int TFD_TIMER_ABSTIME() {
        return TFD_TIMER_ABSTIME;
    }

    public int TFD_TIMER_CANCEL_ON_SET() {
        return TFD_TIMER_CANCEL_ON_SET;
    }

    public Linux.Interface libc() {
        return libc;
    }

    public Runtime jnrRuntime() {
        return jnrRuntime;
    }

    public Tuple3<Object, String, String> getErrnoInfo() {
        int errno = LastError.getLastError(this.jnrRuntime());
        String name = this.libc().strerrorname_np(errno);
        String desc = this.libc().strerrordesc_np(errno);
        return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(errno), name, desc);
    }

    public String getErrnoInfoString() {
        Tuple3<Object, String, String> tuple3 = this.getErrnoInfo();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int errno = BoxesRunTime.unboxToInt(tuple3._1());
        String name = tuple3._2();
        String desc = tuple3._3();
        Tuple3<Integer, String, String> tuple32 = Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(errno), name, desc);
        int errno2 = BoxesRunTime.unboxToInt(tuple32._1());
        String name2 = tuple32._2();
        String desc2 = tuple32._3();
        return new StringBuilder(4).append(name2).append("/").append(errno2).append(" - ").append(desc2).toString();
    }

    public POSIX posix() {
        return posix;
    }
}

