/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.sandmann;

import eu.geekplace.sandmann.Command;
import eu.geekplace.sandmann.ControlSocket$;
import eu.geekplace.sandmann.Exit$;
import eu.geekplace.sandmann.Hibernate$;
import eu.geekplace.sandmann.Sandmann;
import eu.geekplace.sandmann.Suspend$;
import eu.geekplace.scala.systemd.Systemd$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipalLookupService;
import jdk.net.ExtendedSocketOptions;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logger$;
import org.apache.logging.log4j.scala.Logging;
import org.apache.logging.log4j.spi.ExtendedLogger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1$mcZI$sp;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try$;

public class ControlSocket
implements Logging {
    private ExtendedLogger logger;
    private final Sandmann sandmann;
    private volatile Option<Thread> thread;

    public static UnixDomainSocketAddress address() {
        return ControlSocket$.MODULE$.address();
    }

    public ControlSocket(Sandmann sandmann) {
        this.sandmann = sandmann;
        Logging.$init$(this);
        this.thread = None$.MODULE$;
        Statics.releaseFence();
    }

    @Override
    public ExtendedLogger logger() {
        return this.logger;
    }

    @Override
    public void org$apache$logging$log4j$scala$Logging$_setter_$logger_$eq(ExtendedLogger x$0) {
        this.logger = x$0;
    }

    public void start() {
        ControlSocket controlSocket = this;
        synchronized (controlSocket) {
            if (!this.thread.isEmpty()) {
                throw new IllegalStateException("Must terminate previous control socket thread first");
            }
            ServerSocketChannel serverChannel = ServerSocketChannel.open(StandardProtocolFamily.UNIX);
            serverChannel.bind(ControlSocket$.MODULE$.address());
            ExtendedLogger Logger_this = this.logger();
            if (Logger_this.isEnabled(Level.INFO)) {
                Logger_this.log(Level.INFO, "Bound {} to {}".toString(), (Object[])Arrays$.MODULE$.seqToArray(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{serverChannel, ControlSocket$.MODULE$.address()}), Object.class));
            }
            if (Systemd$.MODULE$.isRunningUnderSystemd()) {
                Path socketPath = ControlSocket$.MODULE$.address().getPath();
                UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
                GroupPrincipal group2 = lookupService.lookupPrincipalByGroupName("sandmann-ctrl");
                PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(socketPath, PosixFileAttributeView.class, new LinkOption[0]);
                fileAttributeView.setGroup(group2);
                fileAttributeView.setPermissions(PosixFilePermissions.fromString("rw-rw----"));
            }
            Runnable acceptLoop = () -> {
                ExtendedLogger Logger_this = this.logger();
                if (Logger_this.isEnabled(Level.DEBUG)) {
                    Logger_this.log(Level.DEBUG, "Starting to accept connections on {}".toString(), (Object)serverChannel);
                }
                try {
                    try {
                        this.loop$1(serverChannel);
                    }
                    catch (ClosedByInterruptException i) {
                        ExtendedLogger Logger_this2 = this.logger();
                        if (Logger_this2.isEnabled(Level.DEBUG)) {
                            Logger$.MODULE$.logMessage$extension(Logger_this2, Level.DEBUG, null, "Exiting".toString(), null);
                        }
                    }
                    catch (Throwable e) {
                        ExtendedLogger Logger_this3 = this.logger();
                        if (Logger_this3.isEnabled(Level.ERROR)) {
                            Logger$.MODULE$.logMessage$extension(Logger_this3, Level.ERROR, null, "error".toString(), e);
                        }
                    }
                }
                finally {
                    serverChannel.close();
                    Files.delete(ControlSocket$.MODULE$.address().getPath());
                }
            };
            Thread t = Thread.ofVirtual().name(new StringBuilder(9).append(serverChannel).append(" listener").toString()).unstarted(acceptLoop);
            t.setDaemon(true);
            t.start();
            this.thread = Some$.MODULE$.apply(t);
        }
    }

    public void stop() {
        ControlSocket controlSocket = this;
        synchronized (controlSocket) {
            Option<Thread> option = this.thread;
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("stop() invoked but no thread running");
            }
            if (!(option instanceof Some)) {
                throw new MatchError(option);
            }
            Thread t = (Thread)((Some)option).value();
            t.interrupt();
            this.thread = None$.MODULE$;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleConnection(SocketChannel channel) {
        block20: {
            block19: {
                try {
                    peercred = channel.getOption(ExtendedSocketOptions.SO_PEERCRED);
                    Logger_this = this.logger();
                    if (Logger_this.isEnabled(Level.INFO)) {
                        Logger_this.log(Level.INFO, "Handling {} with peercred {}".toString(), (Object[])Arrays$.MODULE$.seqToArray(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{channel, peercred}), Object.class));
                    }
                    buffer = ByteBuffer.allocate(1024);
lbl8:
                    // 2 sources

                    while (true) {
                        bytesRead = channel.read(buffer);
                        if (bytesRead < 0) {
                            Logger_this = this.logger();
                            if (Logger_this.isEnabled(Level.DEBUG)) {
                                Logger_this.log(Level.DEBUG, "Received {}, client closed {}".toString(), (Object[])Arrays$.MODULE$.seqToArray(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{BoxesRunTime.boxToInteger(bytesRead), channel}), Object.class));
                            }
                            break block19;
                        }
                        newLinePosOption = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), buffer.position()).find((JFunction1$mcZI$sp)LambdaMetafactory.altMetafactory(null, null, null, (I)Z, $anonfun$3(java.nio.ByteBuffer int ), (I)Z)((ByteBuffer)buffer));
                        var8_7 = newLinePosOption;
                        if (var8_7 instanceof Some) {
                            newLinePos = BoxesRunTime.unboxToInt(((Some)var8_7).value());
                            bytes = new byte[newLinePos];
                            buffer.flip();
                            buffer.get(bytes, 0, newLinePos);
                            buffer.position(newLinePos).limit(bytesRead).compact();
                            if (buffer.position() != bytesRead - newLinePos) {
                                throw Scala3RunTime$.MODULE$.assertFailed();
                            }
                        }
                        ** GOTO lbl59
                        break;
                    }
                }
                catch (ClosedChannelException e) {
                    Logger_this = this.logger();
                    if (Logger_this.isEnabled(Level.DEBUG)) {
                        Logger_this.log(Level.DEBUG, "Channel {} closed".toString(), (Object)channel, (Object)e);
                    }
                    break block20;
                }
                catch (Throwable e) {
                    Logger_this = this.logger();
                    if (Logger_this.isEnabled(Level.WARN)) {
                        Logger_this.log(Level.WARN, "Exception while handling {}".toString(), (Object)channel, (Object)e);
                    }
                    break block20;
                }
                catch (Throwable var22_22) {
                    channel.close();
                    throw var22_22;
                }
                {
                    message = new String(bytes);
                    commandDecodeResult = Try$.MODULE$.apply((Function0<Command> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$4(java.lang.String ), ()Leu/geekplace/sandmann/Command;)((String)message));
                    var13_12 = commandDecodeResult;
                    if (var13_12 instanceof Success) {
                        command = (Command)((Success)var13_12).value();
                        Logger_this = this.logger();
                        if (Logger_this.isEnabled(Level.DEBUG)) {
                            Logger_this.log(Level.DEBUG, "Received {} from {}".toString(), (Object[])Arrays$.MODULE$.seqToArray(ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{command, channel}), Object.class));
                        }
                        this.sandmann.enqueue(command);
                        ControlSocket.sendResponse$1(channel, "ENQUEUED");
                        ** continue;
                    }
                    if (var13_12 instanceof Failure) {
                        e = ((Failure)var13_12).exception();
                        ControlSocket.sendResponse$1(channel, new StringBuilder(9).append("FAILURE: ").append(e).toString());
                        throw e;
                    }
                    throw new MatchError(var13_12);
lbl59:
                    // 1 sources

                    if (None$.MODULE$.equals(var8_7) && buffer.position() == buffer.capacity()) {
                        Logger_this = this.logger();
                        if (Logger_this.isEnabled(Level.WARN)) {
                            Logger_this.log(Level.WARN, "Client failed to send command within 1024 bytes on {}".toString(), (Object)channel);
                        }
                        break block19;
                    }
                    throw new MatchError(var8_7);
                }
            }
            channel.close();
            return;
        }
        channel.close();
    }

    private final void loop$1(ServerSocketChannel serverChannel$2) {
        while (true) {
            SocketChannel channel = serverChannel$2.accept();
            Thread thread = Thread.ofVirtual().name(new StringBuilder(8).append(channel).append(" handler").toString()).unstarted(() -> this.handleConnection(channel));
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static final /* synthetic */ boolean $anonfun$3(ByteBuffer buffer$1, int i) {
        return buffer$1.get(i) == 10;
    }

    private static final Command $anonfun$4(String message$1) {
        String string2 = message$1.trim();
        switch (string2 == null ? 0 : string2.hashCode()) {
            case -1852006340: {
                if (!"suspend".equals(string2)) break;
                return Suspend$.MODULE$;
            }
            case -903964590: {
                if (!"hibernate".equals(string2)) break;
                return Hibernate$.MODULE$;
            }
            case 3127582: {
                if (!"exit".equals(string2)) break;
                return Exit$.MODULE$;
            }
        }
        String unknown = string2;
        throw new Exception(new StringBuilder(17).append("Unknown command: ").append(unknown).toString());
    }

    private static final void sendResponse$1(SocketChannel channel$2, String response) {
        byte[] bytes = new StringBuilder(14).append(response).append("\nEND RESPONSE\n").toString().getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        while (buffer.hasRemaining()) {
            channel$2.write(buffer);
        }
    }
}

