package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataCorrectTaskDetail invokes the dms_enterprise.GetDataCorrectTaskDetail API synchronously
func (client *Client) GetDataCorrectTaskDetail(request *GetDataCorrectTaskDetailRequest) (response *GetDataCorrectTaskDetailResponse, err error) {
	response = CreateGetDataCorrectTaskDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataCorrectTaskDetailWithChan invokes the dms_enterprise.GetDataCorrectTaskDetail API asynchronously
func (client *Client) GetDataCorrectTaskDetailWithChan(request *GetDataCorrectTaskDetailRequest) (<-chan *GetDataCorrectTaskDetailResponse, <-chan error) {
	responseChan := make(chan *GetDataCorrectTaskDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataCorrectTaskDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataCorrectTaskDetailWithCallback invokes the dms_enterprise.GetDataCorrectTaskDetail API asynchronously
func (client *Client) GetDataCorrectTaskDetailWithCallback(request *GetDataCorrectTaskDetailRequest, callback func(response *GetDataCorrectTaskDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataCorrectTaskDetailResponse
		var err error
		defer close(result)
		response, err = client.GetDataCorrectTaskDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataCorrectTaskDetailRequest is the request struct for api GetDataCorrectTaskDetail
type GetDataCorrectTaskDetailRequest struct {
	*requests.RpcRequest
	OrderId requests.Integer `position:"Query" name:"OrderId"`
	Tid     requests.Integer `position:"Query" name:"Tid"`
}

// GetDataCorrectTaskDetailResponse is the response struct for api GetDataCorrectTaskDetail
type GetDataCorrectTaskDetailResponse struct {
	*responses.BaseResponse
	RequestId             string                `json:"RequestId" xml:"RequestId"`
	Success               bool                  `json:"Success" xml:"Success"`
	ErrorMessage          string                `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode             string                `json:"ErrorCode" xml:"ErrorCode"`
	DataCorrectTaskDetail DataCorrectTaskDetail `json:"DataCorrectTaskDetail" xml:"DataCorrectTaskDetail"`
}

// CreateGetDataCorrectTaskDetailRequest creates a request to invoke GetDataCorrectTaskDetail API
func CreateGetDataCorrectTaskDetailRequest() (request *GetDataCorrectTaskDetailRequest) {
	request = &GetDataCorrectTaskDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetDataCorrectTaskDetail", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDataCorrectTaskDetailResponse creates a response to parse from GetDataCorrectTaskDetail response
func CreateGetDataCorrectTaskDetailResponse() (response *GetDataCorrectTaskDetailResponse) {
	response = &GetDataCorrectTaskDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
