package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelRepoBuildRecord invokes the cr.CancelRepoBuildRecord API synchronously
// api document: https://help.aliyun.com/api/cr/cancelrepobuildrecord.html
func (client *Client) CancelRepoBuildRecord(request *CancelRepoBuildRecordRequest) (response *CancelRepoBuildRecordResponse, err error) {
	response = CreateCancelRepoBuildRecordResponse()
	err = client.DoAction(request, response)
	return
}

// CancelRepoBuildRecordWithChan invokes the cr.CancelRepoBuildRecord API asynchronously
// api document: https://help.aliyun.com/api/cr/cancelrepobuildrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelRepoBuildRecordWithChan(request *CancelRepoBuildRecordRequest) (<-chan *CancelRepoBuildRecordResponse, <-chan error) {
	responseChan := make(chan *CancelRepoBuildRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelRepoBuildRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelRepoBuildRecordWithCallback invokes the cr.CancelRepoBuildRecord API asynchronously
// api document: https://help.aliyun.com/api/cr/cancelrepobuildrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CancelRepoBuildRecordWithCallback(request *CancelRepoBuildRecordRequest, callback func(response *CancelRepoBuildRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelRepoBuildRecordResponse
		var err error
		defer close(result)
		response, err = client.CancelRepoBuildRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelRepoBuildRecordRequest is the request struct for api CancelRepoBuildRecord
type CancelRepoBuildRecordRequest struct {
	*requests.RpcRequest
	BuildRecordId string `position:"Query" name:"BuildRecordId"`
	RepoId        string `position:"Query" name:"RepoId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
}

// CancelRepoBuildRecordResponse is the response struct for api CancelRepoBuildRecord
type CancelRepoBuildRecordResponse struct {
	*responses.BaseResponse
	CancelRepoBuildRecordIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
	Code                           string `json:"Code" xml:"Code"`
	RequestId                      string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelRepoBuildRecordRequest creates a request to invoke CancelRepoBuildRecord API
func CreateCancelRepoBuildRecordRequest() (request *CancelRepoBuildRecordRequest) {
	request = &CancelRepoBuildRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "CancelRepoBuildRecord", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelRepoBuildRecordResponse creates a response to parse from CancelRepoBuildRecord response
func CreateCancelRepoBuildRecordResponse() (response *CancelRepoBuildRecordResponse) {
	response = &CancelRepoBuildRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
