import { useState } from "react";
function makeAdapter() {
  const adapter = {
    replace(location) {
      window.history.replaceState(location.state, "", location.search || "?");
    },
    push(location) {
      window.history.pushState(location.state, "", location.search || "?");
    },
    get location() {
      return window.location;
    }
  };
  return adapter;
}
const WindowHistoryAdapter = ({
  children
}) => {
  const [adapter] = useState(makeAdapter);
  return children(adapter);
};
export {
  WindowHistoryAdapter
};
