'use client';
'use strict';

var dayjs = require('dayjs');
var timezonePlugin = require('dayjs/plugin/timezone.js');
var utcPlugin = require('dayjs/plugin/utc.js');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var dayjs__default = /*#__PURE__*/_interopDefault(dayjs);
var timezonePlugin__default = /*#__PURE__*/_interopDefault(timezonePlugin);
var utcPlugin__default = /*#__PURE__*/_interopDefault(utcPlugin);

dayjs__default.default.extend(utcPlugin__default.default);
dayjs__default.default.extend(timezonePlugin__default.default);
function getTimezoneOffset(date, timezone) {
  if (timezone) {
    return dayjs__default.default(date).tz(timezone).utcOffset() + date.getTimezoneOffset();
  }
  return 0;
}

exports.getTimezoneOffset = getTimezoneOffset;
//# sourceMappingURL=get-timezone-offset.cjs.map
