//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfusernotification?language=objc)
#[repr(C)]
pub struct CFUserNotification {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFUserNotification"]
    unsafe impl CFUserNotification {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfusernotificationcallback?language=objc)
#[cfg(feature = "CFBase")]
pub type CFUserNotificationCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFUserNotification, CFOptionFlags)>;

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFUserNotification {
    #[doc(alias = "CFUserNotificationGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFUserNotificationGetTypeID() -> CFTypeID;
        }
        unsafe { CFUserNotificationGetTypeID() }
    }
}

#[cfg(all(feature = "CFBase", feature = "CFDate", feature = "CFDictionary"))]
#[inline]
pub unsafe extern "C-unwind" fn CFUserNotificationCreate(
    allocator: Option<&CFAllocator>,
    timeout: CFTimeInterval,
    flags: CFOptionFlags,
    error: *mut i32,
    dictionary: Option<&CFDictionary>,
) -> Option<CFRetained<CFUserNotification>> {
    extern "C-unwind" {
        fn CFUserNotificationCreate(
            allocator: Option<&CFAllocator>,
            timeout: CFTimeInterval,
            flags: CFOptionFlags,
            error: *mut i32,
            dictionary: Option<&CFDictionary>,
        ) -> Option<NonNull<CFUserNotification>>;
    }
    let ret = unsafe { CFUserNotificationCreate(allocator, timeout, flags, error, dictionary) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFDate"))]
    pub fn CFUserNotificationReceiveResponse(
        user_notification: &CFUserNotification,
        timeout: CFTimeInterval,
        response_flags: *mut CFOptionFlags,
    ) -> i32;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFUserNotificationGetResponseValue(
    user_notification: &CFUserNotification,
    key: Option<&CFString>,
    idx: CFIndex,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFUserNotificationGetResponseValue(
            user_notification: &CFUserNotification,
            key: Option<&CFString>,
            idx: CFIndex,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFUserNotificationGetResponseValue(user_notification, key, idx) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFDictionary")]
#[inline]
pub unsafe extern "C-unwind" fn CFUserNotificationGetResponseDictionary(
    user_notification: &CFUserNotification,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFUserNotificationGetResponseDictionary(
            user_notification: &CFUserNotification,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CFUserNotificationGetResponseDictionary(user_notification) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFDate", feature = "CFDictionary"))]
    pub fn CFUserNotificationUpdate(
        user_notification: &CFUserNotification,
        timeout: CFTimeInterval,
        flags: CFOptionFlags,
        dictionary: Option<&CFDictionary>,
    ) -> i32;
}

extern "C-unwind" {
    pub fn CFUserNotificationCancel(user_notification: &CFUserNotification) -> i32;
}

#[cfg(all(feature = "CFBase", feature = "CFRunLoop"))]
#[inline]
pub unsafe extern "C-unwind" fn CFUserNotificationCreateRunLoopSource(
    allocator: Option<&CFAllocator>,
    user_notification: Option<&CFUserNotification>,
    callout: CFUserNotificationCallBack,
    order: CFIndex,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn CFUserNotificationCreateRunLoopSource(
            allocator: Option<&CFAllocator>,
            user_notification: Option<&CFUserNotification>,
            callout: CFUserNotificationCallBack,
            order: CFIndex,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe {
        CFUserNotificationCreateRunLoopSource(allocator, user_notification, callout, order)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFDate", feature = "CFURL"))]
    pub fn CFUserNotificationDisplayNotice(
        timeout: CFTimeInterval,
        flags: CFOptionFlags,
        icon_url: Option<&CFURL>,
        sound_url: Option<&CFURL>,
        localization_url: Option<&CFURL>,
        alert_header: Option<&CFString>,
        alert_message: Option<&CFString>,
        default_button_title: Option<&CFString>,
    ) -> i32;
}

extern "C-unwind" {
    #[cfg(all(feature = "CFBase", feature = "CFDate", feature = "CFURL"))]
    pub fn CFUserNotificationDisplayAlert(
        timeout: CFTimeInterval,
        flags: CFOptionFlags,
        icon_url: Option<&CFURL>,
        sound_url: Option<&CFURL>,
        localization_url: Option<&CFURL>,
        alert_header: Option<&CFString>,
        alert_message: Option<&CFString>,
        default_button_title: Option<&CFString>,
        alternate_button_title: Option<&CFString>,
        other_button_title: Option<&CFString>,
        response_flags: *mut CFOptionFlags,
    ) -> i32;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationstopalertlevel?language=objc)
#[cfg(feature = "CFBase")]
pub const kCFUserNotificationStopAlertLevel: CFOptionFlags = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationnotealertlevel?language=objc)
#[cfg(feature = "CFBase")]
pub const kCFUserNotificationNoteAlertLevel: CFOptionFlags = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationcautionalertlevel?language=objc)
#[cfg(feature = "CFBase")]
pub const kCFUserNotificationCautionAlertLevel: CFOptionFlags = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationplainalertlevel?language=objc)
#[cfg(feature = "CFBase")]
pub const kCFUserNotificationPlainAlertLevel: CFOptionFlags = 3;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationdefaultresponse?language=objc)
#[cfg(feature = "CFBase")]
pub const kCFUserNotificationDefaultResponse: CFOptionFlags = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationalternateresponse?language=objc)
#[cfg(feature = "CFBase")]
pub const kCFUserNotificationAlternateResponse: CFOptionFlags = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationotherresponse?language=objc)
#[cfg(feature = "CFBase")]
pub const kCFUserNotificationOtherResponse: CFOptionFlags = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationcancelresponse?language=objc)
#[cfg(feature = "CFBase")]
pub const kCFUserNotificationCancelResponse: CFOptionFlags = 3;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationnodefaultbuttonflag?language=objc)
#[cfg(feature = "CFBase")]
pub const kCFUserNotificationNoDefaultButtonFlag: CFOptionFlags = 1 << 5;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationuseradiobuttonsflag?language=objc)
#[cfg(feature = "CFBase")]
pub const kCFUserNotificationUseRadioButtonsFlag: CFOptionFlags = 1 << 6;

// TODO: pub fn CFUserNotificationCheckBoxChecked(i: CFIndex,) -> CFOptionFlags;

// TODO: pub fn CFUserNotificationSecureTextField(i: CFIndex,) -> CFOptionFlags;

// TODO: pub fn CFUserNotificationPopUpSelection(n: CFIndex,) -> CFOptionFlags;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationiconurlkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationIconURLKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationsoundurlkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationSoundURLKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationlocalizationurlkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationLocalizationURLKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationalertheaderkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationAlertHeaderKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationalertmessagekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationAlertMessageKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationdefaultbuttontitlekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationDefaultButtonTitleKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationalternatebuttontitlekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationAlternateButtonTitleKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationotherbuttontitlekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationOtherButtonTitleKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationprogressindicatorvaluekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationProgressIndicatorValueKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationpopuptitleskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationPopUpTitlesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationtextfieldtitleskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationTextFieldTitlesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationcheckboxtitleskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationCheckBoxTitlesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationtextfieldvalueskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationTextFieldValuesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationpopupselectionkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationPopUpSelectionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationalerttopmostkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationAlertTopMostKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationkeyboardtypeskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFUserNotificationKeyboardTypesKey: Option<&'static CFString>;
}
