package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncUnionOrder invokes the unimkt.SyncUnionOrder API synchronously
func (client *Client) SyncUnionOrder(request *SyncUnionOrderRequest) (response *SyncUnionOrderResponse, err error) {
	response = CreateSyncUnionOrderResponse()
	err = client.DoAction(request, response)
	return
}

// SyncUnionOrderWithChan invokes the unimkt.SyncUnionOrder API asynchronously
func (client *Client) SyncUnionOrderWithChan(request *SyncUnionOrderRequest) (<-chan *SyncUnionOrderResponse, <-chan error) {
	responseChan := make(chan *SyncUnionOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncUnionOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncUnionOrderWithCallback invokes the unimkt.SyncUnionOrder API asynchronously
func (client *Client) SyncUnionOrderWithCallback(request *SyncUnionOrderRequest, callback func(response *SyncUnionOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncUnionOrderResponse
		var err error
		defer close(result)
		response, err = client.SyncUnionOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncUnionOrderRequest is the request struct for api SyncUnionOrder
type SyncUnionOrderRequest struct {
	*requests.RpcRequest
	TaskType           string           `position:"Query" name:"TaskType"`
	RealCostAmount     requests.Integer `position:"Query" name:"RealCostAmount"`
	TaskBizType        string           `position:"Query" name:"TaskBizType"`
	Sex                string           `position:"Query" name:"Sex"`
	BrandUserId        requests.Integer `position:"Query" name:"BrandUserId"`
	BrandName          string           `position:"Query" name:"BrandName"`
	ProxyUserId        requests.Integer `position:"Query" name:"ProxyUserId"`
	DeviceId           string           `position:"Query" name:"DeviceId"`
	HolderId           string           `position:"Query" name:"HolderId"`
	BizSerialNumber    string           `position:"Query" name:"BizSerialNumber"`
	TaskRuleType       string           `position:"Query" name:"TaskRuleType"`
	IndustryLabelBagId requests.Integer `position:"Query" name:"IndustryLabelBagId"`
	ApplyPrice         requests.Integer `position:"Query" name:"ApplyPrice"`
	ExtendInfo         string           `position:"Query" name:"ExtendInfo"`
	ChannelId          string           `position:"Query" name:"ChannelId"`
	Age                requests.Integer `position:"Query" name:"Age"`
	TaskId             requests.Integer `position:"Query" name:"TaskId"`
	Status             string           `position:"Query" name:"Status"`
}

// SyncUnionOrderResponse is the response struct for api SyncUnionOrder
type SyncUnionOrderResponse struct {
	*responses.BaseResponse
	Msg           string `json:"Msg" xml:"Msg"`
	AliPayOrderId string `json:"AliPayOrderId" xml:"AliPayOrderId"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ErrorCode     string `json:"ErrorCode" xml:"ErrorCode"`
	Status        bool   `json:"Status" xml:"Status"`
}

// CreateSyncUnionOrderRequest creates a request to invoke SyncUnionOrder API
func CreateSyncUnionOrderRequest() (request *SyncUnionOrderRequest) {
	request = &SyncUnionOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "SyncUnionOrder", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSyncUnionOrderResponse creates a response to parse from SyncUnionOrder response
func CreateSyncUnionOrderResponse() (response *SyncUnionOrderResponse) {
	response = &SyncUnionOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
