package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnDDoSTrafficInfo invokes the scdn.DescribeScdnDDoSTrafficInfo API synchronously
func (client *Client) DescribeScdnDDoSTrafficInfo(request *DescribeScdnDDoSTrafficInfoRequest) (response *DescribeScdnDDoSTrafficInfoResponse, err error) {
	response = CreateDescribeScdnDDoSTrafficInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnDDoSTrafficInfoWithChan invokes the scdn.DescribeScdnDDoSTrafficInfo API asynchronously
func (client *Client) DescribeScdnDDoSTrafficInfoWithChan(request *DescribeScdnDDoSTrafficInfoRequest) (<-chan *DescribeScdnDDoSTrafficInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnDDoSTrafficInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnDDoSTrafficInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnDDoSTrafficInfoWithCallback invokes the scdn.DescribeScdnDDoSTrafficInfo API asynchronously
func (client *Client) DescribeScdnDDoSTrafficInfoWithCallback(request *DescribeScdnDDoSTrafficInfoRequest, callback func(response *DescribeScdnDDoSTrafficInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnDDoSTrafficInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnDDoSTrafficInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnDDoSTrafficInfoRequest is the request struct for api DescribeScdnDDoSTrafficInfo
type DescribeScdnDDoSTrafficInfoRequest struct {
	*requests.RpcRequest
	Line      string           `position:"Query" name:"Line"`
	StartTime string           `position:"Query" name:"StartTime"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeScdnDDoSTrafficInfoResponse is the response struct for api DescribeScdnDDoSTrafficInfo
type DescribeScdnDDoSTrafficInfoResponse struct {
	*responses.BaseResponse
	RequestId  string                                  `json:"RequestId" xml:"RequestId"`
	BpsDrops   BpsDrops                                `json:"BpsDrops" xml:"BpsDrops"`
	BpsTotals  BpsTotals                               `json:"BpsTotals" xml:"BpsTotals"`
	PpsTotals  PpsTotals                               `json:"PpsTotals" xml:"PpsTotals"`
	PpsDrops   PpsDrops                                `json:"PpsDrops" xml:"PpsDrops"`
	TimeScopes TimeScopesInDescribeScdnDDoSTrafficInfo `json:"TimeScopes" xml:"TimeScopes"`
}

// CreateDescribeScdnDDoSTrafficInfoRequest creates a request to invoke DescribeScdnDDoSTrafficInfo API
func CreateDescribeScdnDDoSTrafficInfoRequest() (request *DescribeScdnDDoSTrafficInfoRequest) {
	request = &DescribeScdnDDoSTrafficInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnDDoSTrafficInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeScdnDDoSTrafficInfoResponse creates a response to parse from DescribeScdnDDoSTrafficInfo response
func CreateDescribeScdnDDoSTrafficInfoResponse() (response *DescribeScdnDDoSTrafficInfoResponse) {
	response = &DescribeScdnDDoSTrafficInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
