package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnCcTopIp invokes the scdn.DescribeScdnCcTopIp API synchronously
func (client *Client) DescribeScdnCcTopIp(request *DescribeScdnCcTopIpRequest) (response *DescribeScdnCcTopIpResponse, err error) {
	response = CreateDescribeScdnCcTopIpResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnCcTopIpWithChan invokes the scdn.DescribeScdnCcTopIp API asynchronously
func (client *Client) DescribeScdnCcTopIpWithChan(request *DescribeScdnCcTopIpRequest) (<-chan *DescribeScdnCcTopIpResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnCcTopIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnCcTopIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnCcTopIpWithCallback invokes the scdn.DescribeScdnCcTopIp API asynchronously
func (client *Client) DescribeScdnCcTopIpWithCallback(request *DescribeScdnCcTopIpRequest, callback func(response *DescribeScdnCcTopIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnCcTopIpResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnCcTopIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnCcTopIpRequest is the request struct for api DescribeScdnCcTopIp
type DescribeScdnCcTopIpRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber string           `position:"Query" name:"PageNumber"`
	PageSize   string           `position:"Query" name:"PageSize"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeScdnCcTopIpResponse is the response struct for api DescribeScdnCcTopIp
type DescribeScdnCcTopIpResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	Total            string           `json:"Total" xml:"Total"`
	DomainName       string           `json:"DomainName" xml:"DomainName"`
	AttackIpDataList AttackIpDataList `json:"AttackIpDataList" xml:"AttackIpDataList"`
}

// CreateDescribeScdnCcTopIpRequest creates a request to invoke DescribeScdnCcTopIp API
func CreateDescribeScdnCcTopIpRequest() (request *DescribeScdnCcTopIpRequest) {
	request = &DescribeScdnCcTopIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnCcTopIp", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeScdnCcTopIpResponse creates a response to parse from DescribeScdnCcTopIp response
func CreateDescribeScdnCcTopIpResponse() (response *DescribeScdnCcTopIpResponse) {
	response = &DescribeScdnCcTopIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
