package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EditThesaurusForApi invokes the qualitycheck.EditThesaurusForApi API synchronously
func (client *Client) EditThesaurusForApi(request *EditThesaurusForApiRequest) (response *EditThesaurusForApiResponse, err error) {
	response = CreateEditThesaurusForApiResponse()
	err = client.DoAction(request, response)
	return
}

// EditThesaurusForApiWithChan invokes the qualitycheck.EditThesaurusForApi API asynchronously
func (client *Client) EditThesaurusForApiWithChan(request *EditThesaurusForApiRequest) (<-chan *EditThesaurusForApiResponse, <-chan error) {
	responseChan := make(chan *EditThesaurusForApiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EditThesaurusForApi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EditThesaurusForApiWithCallback invokes the qualitycheck.EditThesaurusForApi API asynchronously
func (client *Client) EditThesaurusForApiWithCallback(request *EditThesaurusForApiRequest, callback func(response *EditThesaurusForApiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EditThesaurusForApiResponse
		var err error
		defer close(result)
		response, err = client.EditThesaurusForApi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EditThesaurusForApiRequest is the request struct for api EditThesaurusForApi
type EditThesaurusForApiRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// EditThesaurusForApiResponse is the response struct for api EditThesaurusForApi
type EditThesaurusForApiResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      int64  `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateEditThesaurusForApiRequest creates a request to invoke EditThesaurusForApi API
func CreateEditThesaurusForApiRequest() (request *EditThesaurusForApiRequest) {
	request = &EditThesaurusForApiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "EditThesaurusForApi", "", "")
	request.Method = requests.POST
	return
}

// CreateEditThesaurusForApiResponse creates a response to parse from EditThesaurusForApi response
func CreateEditThesaurusForApiResponse() (response *EditThesaurusForApiResponse) {
	response = &EditThesaurusForApiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
