package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOutboundCallNumber invokes the outboundbot.CreateOutboundCallNumber API synchronously
func (client *Client) CreateOutboundCallNumber(request *CreateOutboundCallNumberRequest) (response *CreateOutboundCallNumberResponse, err error) {
	response = CreateCreateOutboundCallNumberResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOutboundCallNumberWithChan invokes the outboundbot.CreateOutboundCallNumber API asynchronously
func (client *Client) CreateOutboundCallNumberWithChan(request *CreateOutboundCallNumberRequest) (<-chan *CreateOutboundCallNumberResponse, <-chan error) {
	responseChan := make(chan *CreateOutboundCallNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOutboundCallNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOutboundCallNumberWithCallback invokes the outboundbot.CreateOutboundCallNumber API asynchronously
func (client *Client) CreateOutboundCallNumberWithCallback(request *CreateOutboundCallNumberRequest, callback func(response *CreateOutboundCallNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOutboundCallNumberResponse
		var err error
		defer close(result)
		response, err = client.CreateOutboundCallNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOutboundCallNumberRequest is the request struct for api CreateOutboundCallNumber
type CreateOutboundCallNumberRequest struct {
	*requests.RpcRequest
	RateLimitCount  requests.Integer `position:"Query" name:"RateLimitCount"`
	Number          string           `position:"Query" name:"Number"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	RateLimitPeriod requests.Integer `position:"Query" name:"RateLimitPeriod"`
}

// CreateOutboundCallNumberResponse is the response struct for api CreateOutboundCallNumber
type CreateOutboundCallNumberResponse struct {
	*responses.BaseResponse
	Code                 string `json:"Code" xml:"Code"`
	HttpStatusCode       int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message              string `json:"Message" xml:"Message"`
	OutboundCallNumberId string `json:"OutboundCallNumberId" xml:"OutboundCallNumberId"`
	RequestId            string `json:"RequestId" xml:"RequestId"`
	Success              bool   `json:"Success" xml:"Success"`
}

// CreateCreateOutboundCallNumberRequest creates a request to invoke CreateOutboundCallNumber API
func CreateCreateOutboundCallNumberRequest() (request *CreateOutboundCallNumberRequest) {
	request = &CreateOutboundCallNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "CreateOutboundCallNumber", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOutboundCallNumberResponse creates a response to parse from CreateOutboundCallNumber response
func CreateCreateOutboundCallNumberResponse() (response *CreateOutboundCallNumberResponse) {
	response = &CreateOutboundCallNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
