package openanalytics

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProductStatus invokes the openanalytics.GetProductStatus API synchronously
// api document: https://help.aliyun.com/api/openanalytics/getproductstatus.html
func (client *Client) GetProductStatus(request *GetProductStatusRequest) (response *GetProductStatusResponse, err error) {
	response = CreateGetProductStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetProductStatusWithChan invokes the openanalytics.GetProductStatus API asynchronously
// api document: https://help.aliyun.com/api/openanalytics/getproductstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProductStatusWithChan(request *GetProductStatusRequest) (<-chan *GetProductStatusResponse, <-chan error) {
	responseChan := make(chan *GetProductStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProductStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProductStatusWithCallback invokes the openanalytics.GetProductStatus API asynchronously
// api document: https://help.aliyun.com/api/openanalytics/getproductstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProductStatusWithCallback(request *GetProductStatusRequest, callback func(response *GetProductStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProductStatusResponse
		var err error
		defer close(result)
		response, err = client.GetProductStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProductStatusRequest is the request struct for api GetProductStatus
type GetProductStatusRequest struct {
	*requests.RpcRequest
	ProductCode      string `position:"Body" name:"ProductCode"`
	ProductAccessKey string `position:"Body" name:"ProductAccessKey"`
	TargetUid        string `position:"Body" name:"TargetUid"`
	TargetArnRole    string `position:"Body" name:"TargetArnRole"`
}

// GetProductStatusResponse is the response struct for api GetProductStatus
type GetProductStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RegionId  string `json:"RegionId" xml:"RegionId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetProductStatusRequest creates a request to invoke GetProductStatus API
func CreateGetProductStatusRequest() (request *GetProductStatusRequest) {
	request = &GetProductStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics", "2018-03-01", "GetProductStatus", "openanalytics", "openAPI")
	return
}

// CreateGetProductStatusResponse creates a response to parse from GetProductStatus response
func CreateGetProductStatusResponse() (response *GetProductStatusResponse) {
	response = &GetProductStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
