package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnTagLiveResources invokes the live.UnTagLiveResources API synchronously
func (client *Client) UnTagLiveResources(request *UnTagLiveResourcesRequest) (response *UnTagLiveResourcesResponse, err error) {
	response = CreateUnTagLiveResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// UnTagLiveResourcesWithChan invokes the live.UnTagLiveResources API asynchronously
func (client *Client) UnTagLiveResourcesWithChan(request *UnTagLiveResourcesRequest) (<-chan *UnTagLiveResourcesResponse, <-chan error) {
	responseChan := make(chan *UnTagLiveResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnTagLiveResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnTagLiveResourcesWithCallback invokes the live.UnTagLiveResources API asynchronously
func (client *Client) UnTagLiveResourcesWithCallback(request *UnTagLiveResourcesRequest, callback func(response *UnTagLiveResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnTagLiveResourcesResponse
		var err error
		defer close(result)
		response, err = client.UnTagLiveResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnTagLiveResourcesRequest is the request struct for api UnTagLiveResources
type UnTagLiveResourcesRequest struct {
	*requests.RpcRequest
	All          requests.Boolean `position:"Query" name:"All"`
	ResourceId   *[]string        `position:"Query" name:"ResourceId"  type:"Repeated"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType string           `position:"Query" name:"ResourceType"`
	TagKey       *[]string        `position:"Query" name:"TagKey"  type:"Repeated"`
}

// UnTagLiveResourcesResponse is the response struct for api UnTagLiveResources
type UnTagLiveResourcesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnTagLiveResourcesRequest creates a request to invoke UnTagLiveResources API
func CreateUnTagLiveResourcesRequest() (request *UnTagLiveResourcesRequest) {
	request = &UnTagLiveResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UnTagLiveResources", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnTagLiveResourcesResponse creates a response to parse from UnTagLiveResources response
func CreateUnTagLiveResourcesResponse() (response *UnTagLiveResourcesResponse) {
	response = &UnTagLiveResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
