package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetSnapshotCallbackAuth invokes the live.SetSnapshotCallbackAuth API synchronously
func (client *Client) SetSnapshotCallbackAuth(request *SetSnapshotCallbackAuthRequest) (response *SetSnapshotCallbackAuthResponse, err error) {
	response = CreateSetSnapshotCallbackAuthResponse()
	err = client.DoAction(request, response)
	return
}

// SetSnapshotCallbackAuthWithChan invokes the live.SetSnapshotCallbackAuth API asynchronously
func (client *Client) SetSnapshotCallbackAuthWithChan(request *SetSnapshotCallbackAuthRequest) (<-chan *SetSnapshotCallbackAuthResponse, <-chan error) {
	responseChan := make(chan *SetSnapshotCallbackAuthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetSnapshotCallbackAuth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetSnapshotCallbackAuthWithCallback invokes the live.SetSnapshotCallbackAuth API asynchronously
func (client *Client) SetSnapshotCallbackAuthWithCallback(request *SetSnapshotCallbackAuthRequest, callback func(response *SetSnapshotCallbackAuthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetSnapshotCallbackAuthResponse
		var err error
		defer close(result)
		response, err = client.SetSnapshotCallbackAuth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetSnapshotCallbackAuthRequest is the request struct for api SetSnapshotCallbackAuth
type SetSnapshotCallbackAuthRequest struct {
	*requests.RpcRequest
	CallbackAuthKey string           `position:"Query" name:"CallbackAuthKey"`
	DomainName      string           `position:"Query" name:"DomainName"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	CallbackReqAuth string           `position:"Query" name:"CallbackReqAuth"`
}

// SetSnapshotCallbackAuthResponse is the response struct for api SetSnapshotCallbackAuth
type SetSnapshotCallbackAuthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetSnapshotCallbackAuthRequest creates a request to invoke SetSnapshotCallbackAuth API
func CreateSetSnapshotCallbackAuthRequest() (request *SetSnapshotCallbackAuthRequest) {
	request = &SetSnapshotCallbackAuthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SetSnapshotCallbackAuth", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetSnapshotCallbackAuthResponse creates a response to parse from SetSnapshotCallbackAuth response
func CreateSetSnapshotCallbackAuthResponse() (response *SetSnapshotCallbackAuthResponse) {
	response = &SetSnapshotCallbackAuthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
