package itaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIPSegmentsList invokes the itaas.GetIPSegmentsList API synchronously
// api document: https://help.aliyun.com/api/itaas/getipsegmentslist.html
func (client *Client) GetIPSegmentsList(request *GetIPSegmentsListRequest) (response *GetIPSegmentsListResponse, err error) {
	response = CreateGetIPSegmentsListResponse()
	err = client.DoAction(request, response)
	return
}

// GetIPSegmentsListWithChan invokes the itaas.GetIPSegmentsList API asynchronously
// api document: https://help.aliyun.com/api/itaas/getipsegmentslist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetIPSegmentsListWithChan(request *GetIPSegmentsListRequest) (<-chan *GetIPSegmentsListResponse, <-chan error) {
	responseChan := make(chan *GetIPSegmentsListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIPSegmentsList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIPSegmentsListWithCallback invokes the itaas.GetIPSegmentsList API asynchronously
// api document: https://help.aliyun.com/api/itaas/getipsegmentslist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetIPSegmentsListWithCallback(request *GetIPSegmentsListRequest, callback func(response *GetIPSegmentsListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIPSegmentsListResponse
		var err error
		defer close(result)
		response, err = client.GetIPSegmentsList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIPSegmentsListRequest is the request struct for api GetIPSegmentsList
type GetIPSegmentsListRequest struct {
	*requests.RpcRequest
	Clientappid string `position:"Query" name:"Clientappid"`
	Sysfrom     string `position:"Query" name:"Sysfrom"`
	Operator    string `position:"Query" name:"Operator"`
}

// GetIPSegmentsListResponse is the response struct for api GetIPSegmentsList
type GetIPSegmentsListResponse struct {
	*responses.BaseResponse
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	ErrorCode int                          `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string                       `json:"ErrorMsg" xml:"ErrorMsg"`
	Success   bool                         `json:"Success" xml:"Success"`
	Data      DataInGetIPSegmentsList      `json:"Data" xml:"Data"`
	ErrorList ErrorListInGetIPSegmentsList `json:"ErrorList" xml:"ErrorList"`
}

// CreateGetIPSegmentsListRequest creates a request to invoke GetIPSegmentsList API
func CreateGetIPSegmentsListRequest() (request *GetIPSegmentsListRequest) {
	request = &GetIPSegmentsListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ITaaS", "2017-05-05", "GetIPSegmentsList", "itaas", "openAPI")
	return
}

// CreateGetIPSegmentsListResponse creates a response to parse from GetIPSegmentsList response
func CreateGetIPSegmentsListResponse() (response *GetIPSegmentsListResponse) {
	response = &GetIPSegmentsListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
