package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDeviceDistributeJob invokes the iot.CreateDeviceDistributeJob API synchronously
func (client *Client) CreateDeviceDistributeJob(request *CreateDeviceDistributeJobRequest) (response *CreateDeviceDistributeJobResponse, err error) {
	response = CreateCreateDeviceDistributeJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDeviceDistributeJobWithChan invokes the iot.CreateDeviceDistributeJob API asynchronously
func (client *Client) CreateDeviceDistributeJobWithChan(request *CreateDeviceDistributeJobRequest) (<-chan *CreateDeviceDistributeJobResponse, <-chan error) {
	responseChan := make(chan *CreateDeviceDistributeJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDeviceDistributeJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDeviceDistributeJobWithCallback invokes the iot.CreateDeviceDistributeJob API asynchronously
func (client *Client) CreateDeviceDistributeJobWithCallback(request *CreateDeviceDistributeJobRequest, callback func(response *CreateDeviceDistributeJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDeviceDistributeJobResponse
		var err error
		defer close(result)
		response, err = client.CreateDeviceDistributeJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDeviceDistributeJobRequest is the request struct for api CreateDeviceDistributeJob
type CreateDeviceDistributeJobRequest struct {
	*requests.RpcRequest
	Captcha              string                                           `position:"Body" name:"Captcha"`
	SourceInstanceId     string                                           `position:"Body" name:"SourceInstanceId"`
	TargetAliyunId       string                                           `position:"Body" name:"TargetAliyunId"`
	TargetInstanceConfig *[]CreateDeviceDistributeJobTargetInstanceConfig `position:"Body" name:"TargetInstanceConfig"  type:"Repeated"`
	ProductKey           string                                           `position:"Body" name:"ProductKey"`
	ApiProduct           string                                           `position:"Body" name:"ApiProduct"`
	ApiRevision          string                                           `position:"Body" name:"ApiRevision"`
	DeviceName           *[]string                                        `position:"Body" name:"DeviceName"  type:"Repeated"`
	TargetUid            string                                           `position:"Body" name:"TargetUid"`
	Strategy             requests.Integer                                 `position:"Body" name:"Strategy"`
}

// CreateDeviceDistributeJobTargetInstanceConfig is a repeated param struct in CreateDeviceDistributeJobRequest
type CreateDeviceDistributeJobTargetInstanceConfig struct {
	TargetInstanceId string `name:"TargetInstanceId"`
}

// CreateDeviceDistributeJobResponse is the response struct for api CreateDeviceDistributeJob
type CreateDeviceDistributeJobResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	JobId        string `json:"JobId" xml:"JobId"`
}

// CreateCreateDeviceDistributeJobRequest creates a request to invoke CreateDeviceDistributeJob API
func CreateCreateDeviceDistributeJobRequest() (request *CreateDeviceDistributeJobRequest) {
	request = &CreateDeviceDistributeJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateDeviceDistributeJob", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDeviceDistributeJobResponse creates a response to parse from CreateDeviceDistributeJob response
func CreateCreateDeviceDistributeJobResponse() (response *CreateDeviceDistributeJobResponse) {
	response = &CreateDeviceDistributeJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
