package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteQualityEntity invokes the dataworks_public.DeleteQualityEntity API synchronously
func (client *Client) DeleteQualityEntity(request *DeleteQualityEntityRequest) (response *DeleteQualityEntityResponse, err error) {
	response = CreateDeleteQualityEntityResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteQualityEntityWithChan invokes the dataworks_public.DeleteQualityEntity API asynchronously
func (client *Client) DeleteQualityEntityWithChan(request *DeleteQualityEntityRequest) (<-chan *DeleteQualityEntityResponse, <-chan error) {
	responseChan := make(chan *DeleteQualityEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteQualityEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteQualityEntityWithCallback invokes the dataworks_public.DeleteQualityEntity API asynchronously
func (client *Client) DeleteQualityEntityWithCallback(request *DeleteQualityEntityRequest, callback func(response *DeleteQualityEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteQualityEntityResponse
		var err error
		defer close(result)
		response, err = client.DeleteQualityEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteQualityEntityRequest is the request struct for api DeleteQualityEntity
type DeleteQualityEntityRequest struct {
	*requests.RpcRequest
	ProjectName string           `position:"Body" name:"ProjectName"`
	EnvType     string           `position:"Body" name:"EnvType"`
	EntityId    requests.Integer `position:"Body" name:"EntityId"`
}

// DeleteQualityEntityResponse is the response struct for api DeleteQualityEntity
type DeleteQualityEntityResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           bool   `json:"Data" xml:"Data"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateDeleteQualityEntityRequest creates a request to invoke DeleteQualityEntity API
func CreateDeleteQualityEntityRequest() (request *DeleteQualityEntityRequest) {
	request = &DeleteQualityEntityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteQualityEntity", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteQualityEntityResponse creates a response to parse from DeleteQualityEntity response
func CreateDeleteQualityEntityResponse() (response *DeleteQualityEntityResponse) {
	response = &DeleteQualityEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
