package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCmsCallNumOrder invokes the cms.CreateCmsCallNumOrder API synchronously
func (client *Client) CreateCmsCallNumOrder(request *CreateCmsCallNumOrderRequest) (response *CreateCmsCallNumOrderResponse, err error) {
	response = CreateCreateCmsCallNumOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCmsCallNumOrderWithChan invokes the cms.CreateCmsCallNumOrder API asynchronously
func (client *Client) CreateCmsCallNumOrderWithChan(request *CreateCmsCallNumOrderRequest) (<-chan *CreateCmsCallNumOrderResponse, <-chan error) {
	responseChan := make(chan *CreateCmsCallNumOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCmsCallNumOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCmsCallNumOrderWithCallback invokes the cms.CreateCmsCallNumOrder API asynchronously
func (client *Client) CreateCmsCallNumOrderWithCallback(request *CreateCmsCallNumOrderRequest, callback func(response *CreateCmsCallNumOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCmsCallNumOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateCmsCallNumOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCmsCallNumOrderRequest is the request struct for api CreateCmsCallNumOrder
type CreateCmsCallNumOrderRequest struct {
	*requests.RpcRequest
	AutoRenewPeriod requests.Integer `position:"Query" name:"AutoRenewPeriod"`
	Period          requests.Integer `position:"Query" name:"Period"`
	AutoPay         requests.Boolean `position:"Query" name:"AutoPay"`
	AutoUseCoupon   requests.Boolean `position:"Query" name:"AutoUseCoupon"`
	PeriodUnit      string           `position:"Query" name:"PeriodUnit"`
	PhoneCount      string           `position:"Query" name:"PhoneCount"`
}

// CreateCmsCallNumOrderResponse is the response struct for api CreateCmsCallNumOrder
type CreateCmsCallNumOrderResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateCmsCallNumOrderRequest creates a request to invoke CreateCmsCallNumOrder API
func CreateCreateCmsCallNumOrderRequest() (request *CreateCmsCallNumOrderRequest) {
	request = &CreateCmsCallNumOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "CreateCmsCallNumOrder", "Cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCmsCallNumOrderResponse creates a response to parse from CreateCmsCallNumOrder response
func CreateCreateCmsCallNumOrderResponse() (response *CreateCmsCallNumOrderResponse) {
	response = &CreateCmsCallNumOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
